/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.RecordListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRecordsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetRecordsResponse> {
    private final List<Record> records;
    private final String nextShardIterator;
    private final Long millisBehindLatest;

    private GetRecordsResponse(BuilderImpl builder) {
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
        this.millisBehindLatest = builder.millisBehindLatest;
    }

    public List<Record> records() {
        return this.records;
    }

    public String nextShardIterator() {
        return this.nextShardIterator;
    }

    public Long millisBehindLatest() {
        return this.millisBehindLatest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.records() == null ? 0 : this.records().hashCode());
        hashCode = 31 * hashCode + (this.nextShardIterator() == null ? 0 : this.nextShardIterator().hashCode());
        hashCode = 31 * hashCode + (this.millisBehindLatest() == null ? 0 : this.millisBehindLatest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse)((Object)obj);
        if (other.records() == null ^ this.records() == null) {
            return false;
        }
        if (other.records() != null && !other.records().equals(this.records())) {
            return false;
        }
        if (other.nextShardIterator() == null ^ this.nextShardIterator() == null) {
            return false;
        }
        if (other.nextShardIterator() != null && !other.nextShardIterator().equals(this.nextShardIterator())) {
            return false;
        }
        if (other.millisBehindLatest() == null ^ this.millisBehindLatest() == null) {
            return false;
        }
        return other.millisBehindLatest() == null || other.millisBehindLatest().equals(this.millisBehindLatest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        if (this.nextShardIterator() != null) {
            sb.append("NextShardIterator: ").append(this.nextShardIterator()).append(",");
        }
        if (this.millisBehindLatest() != null) {
            sb.append("MillisBehindLatest: ").append(this.millisBehindLatest()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Record> records = new SdkInternalList();
        private String nextShardIterator;
        private Long millisBehindLatest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            this.setRecords(model.records);
            this.setNextShardIterator(model.nextShardIterator);
            this.setMillisBehindLatest(model.millisBehindLatest);
        }

        public final Collection<Record> getRecords() {
            return this.records;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            if (this.records == null) {
                this.records = new SdkInternalList(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
            return this;
        }

        public final void setRecords(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
        }

        @SafeVarargs
        public final void setRecords(Record ... records) {
            if (this.records == null) {
                this.records = new SdkInternalList(records.length);
            }
            for (Record e : records) {
                this.records.add(e);
            }
        }

        public final String getNextShardIterator() {
            return this.nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        public final Long getMillisBehindLatest() {
            return this.millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder nextShardIterator(String var1);

        public Builder millisBehindLatest(Long var1);
    }
}

