/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetShardIteratorRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetShardIteratorRequest> {
    private final String streamName;
    private final String shardId;
    private final String shardIteratorType;
    private final String startingSequenceNumber;
    private final Date timestamp;

    private GetShardIteratorRequest(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.timestamp = builder.timestamp;
    }

    public String streamName() {
        return this.streamName;
    }

    public String shardId() {
        return this.shardId;
    }

    public String shardIteratorType() {
        return this.shardIteratorType;
    }

    public String startingSequenceNumber() {
        return this.startingSequenceNumber;
    }

    public Date timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamName() == null ? 0 : this.streamName().hashCode());
        hashCode = 31 * hashCode + (this.shardId() == null ? 0 : this.shardId().hashCode());
        hashCode = 31 * hashCode + (this.shardIteratorType() == null ? 0 : this.shardIteratorType().hashCode());
        hashCode = 31 * hashCode + (this.startingSequenceNumber() == null ? 0 : this.startingSequenceNumber().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest)((Object)obj);
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.shardId() == null ^ this.shardId() == null) {
            return false;
        }
        if (other.shardId() != null && !other.shardId().equals(this.shardId())) {
            return false;
        }
        if (other.shardIteratorType() == null ^ this.shardIteratorType() == null) {
            return false;
        }
        if (other.shardIteratorType() != null && !other.shardIteratorType().equals(this.shardIteratorType())) {
            return false;
        }
        if (other.startingSequenceNumber() == null ^ this.startingSequenceNumber() == null) {
            return false;
        }
        if (other.startingSequenceNumber() != null && !other.startingSequenceNumber().equals(this.startingSequenceNumber())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        return other.timestamp() == null || other.timestamp().equals(this.timestamp());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.shardId() != null) {
            sb.append("ShardId: ").append(this.shardId()).append(",");
        }
        if (this.shardIteratorType() != null) {
            sb.append("ShardIteratorType: ").append(this.shardIteratorType()).append(",");
        }
        if (this.startingSequenceNumber() != null) {
            sb.append("StartingSequenceNumber: ").append(this.startingSequenceNumber()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String shardId;
        private String shardIteratorType;
        private String startingSequenceNumber;
        private Date timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            this.setStreamName(model.streamName);
            this.setShardId(model.shardId);
            this.setShardIteratorType(model.shardIteratorType);
            this.setStartingSequenceNumber(model.startingSequenceNumber);
            this.setTimestamp(model.timestamp);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getShardIteratorType() {
            return this.shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType.toString());
            return this;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        public final void setShardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType.toString());
        }

        public final String getStartingSequenceNumber() {
            return this.startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final Date getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy((Date)timestamp);
            return this;
        }

        public final void setTimestamp(Date timestamp) {
            this.timestamp = StandardMemberCopier.copy((Date)timestamp);
        }

        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetShardIteratorRequest> {
        public Builder streamName(String var1);

        public Builder shardId(String var1);

        public Builder shardIteratorType(String var1);

        public Builder shardIteratorType(ShardIteratorType var1);

        public Builder startingSequenceNumber(String var1);

        public Builder timestamp(Date var1);
    }
}

