/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.HashKeyRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HashKeyRange
implements StructuredPojo,
ToCopyableBuilder<Builder, HashKeyRange> {
    private final String startingHashKey;
    private final String endingHashKey;

    private HashKeyRange(BuilderImpl builder) {
        this.startingHashKey = builder.startingHashKey;
        this.endingHashKey = builder.endingHashKey;
    }

    public String startingHashKey() {
        return this.startingHashKey;
    }

    public String endingHashKey() {
        return this.endingHashKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.startingHashKey() == null ? 0 : this.startingHashKey().hashCode());
        hashCode = 31 * hashCode + (this.endingHashKey() == null ? 0 : this.endingHashKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HashKeyRange)) {
            return false;
        }
        HashKeyRange other = (HashKeyRange)obj;
        if (other.startingHashKey() == null ^ this.startingHashKey() == null) {
            return false;
        }
        if (other.startingHashKey() != null && !other.startingHashKey().equals(this.startingHashKey())) {
            return false;
        }
        if (other.endingHashKey() == null ^ this.endingHashKey() == null) {
            return false;
        }
        return other.endingHashKey() == null || other.endingHashKey().equals(this.endingHashKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.startingHashKey() != null) {
            sb.append("StartingHashKey: ").append(this.startingHashKey()).append(",");
        }
        if (this.endingHashKey() != null) {
            sb.append("EndingHashKey: ").append(this.endingHashKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HashKeyRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String startingHashKey;
        private String endingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(HashKeyRange model) {
            this.setStartingHashKey(model.startingHashKey);
            this.setEndingHashKey(model.endingHashKey);
        }

        public final String getStartingHashKey() {
            return this.startingHashKey;
        }

        @Override
        public final Builder startingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
            return this;
        }

        public final void setStartingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
        }

        public final String getEndingHashKey() {
            return this.endingHashKey;
        }

        @Override
        public final Builder endingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
            return this;
        }

        public final void setEndingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
        }

        public HashKeyRange build() {
            return new HashKeyRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HashKeyRange> {
        public Builder startingHashKey(String var1);

        public Builder endingHashKey(String var1);
    }
}

