/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.kinesis.model.StreamNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListStreamsResponse> {
    private final List<String> streamNames;
    private final Boolean hasMoreStreams;

    private ListStreamsResponse(BuilderImpl builder) {
        this.streamNames = builder.streamNames;
        this.hasMoreStreams = builder.hasMoreStreams;
    }

    public List<String> streamNames() {
        return this.streamNames;
    }

    public Boolean hasMoreStreams() {
        return this.hasMoreStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.streamNames() == null ? 0 : this.streamNames().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreStreams() == null ? 0 : this.hasMoreStreams().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse)((Object)obj);
        if (other.streamNames() == null ^ this.streamNames() == null) {
            return false;
        }
        if (other.streamNames() != null && !other.streamNames().equals(this.streamNames())) {
            return false;
        }
        if (other.hasMoreStreams() == null ^ this.hasMoreStreams() == null) {
            return false;
        }
        return other.hasMoreStreams() == null || other.hasMoreStreams().equals(this.hasMoreStreams());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.streamNames() != null) {
            sb.append("StreamNames: ").append(this.streamNames()).append(",");
        }
        if (this.hasMoreStreams() != null) {
            sb.append("HasMoreStreams: ").append(this.hasMoreStreams()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> streamNames = new SdkInternalList();
        private Boolean hasMoreStreams;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            this.setStreamNames(model.streamNames);
            this.setHasMoreStreams(model.hasMoreStreams);
        }

        public final Collection<String> getStreamNames() {
            return this.streamNames;
        }

        @Override
        public final Builder streamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamNames(String ... streamNames) {
            if (this.streamNames == null) {
                this.streamNames = new SdkInternalList(streamNames.length);
            }
            for (String e : streamNames) {
                this.streamNames.add(e);
            }
            return this;
        }

        public final void setStreamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
        }

        @SafeVarargs
        public final void setStreamNames(String ... streamNames) {
            if (this.streamNames == null) {
                this.streamNames = new SdkInternalList(streamNames.length);
            }
            for (String e : streamNames) {
                this.streamNames.add(e);
            }
        }

        public final Boolean getHasMoreStreams() {
            return this.hasMoreStreams;
        }

        @Override
        public final Builder hasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
            return this;
        }

        public final void setHasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
        }

        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStreamsResponse> {
        public Builder streamNames(Collection<String> var1);

        public Builder streamNames(String ... var1);

        public Builder hasMoreStreams(Boolean var1);
    }
}

