/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.nio.ByteBuffer;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.kinesis.transform.PutRecordsRequestEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutRecordsRequestEntry
implements StructuredPojo,
ToCopyableBuilder<Builder, PutRecordsRequestEntry> {
    private final ByteBuffer data;
    private final String explicitHashKey;
    private final String partitionKey;

    private PutRecordsRequestEntry(BuilderImpl builder) {
        this.data = builder.data;
        this.explicitHashKey = builder.explicitHashKey;
        this.partitionKey = builder.partitionKey;
    }

    public ByteBuffer data() {
        return this.data;
    }

    public String explicitHashKey() {
        return this.explicitHashKey;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.explicitHashKey() == null ? 0 : this.explicitHashKey().hashCode());
        hashCode = 31 * hashCode + (this.partitionKey() == null ? 0 : this.partitionKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsRequestEntry)) {
            return false;
        }
        PutRecordsRequestEntry other = (PutRecordsRequestEntry)obj;
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.explicitHashKey() == null ^ this.explicitHashKey() == null) {
            return false;
        }
        if (other.explicitHashKey() != null && !other.explicitHashKey().equals(this.explicitHashKey())) {
            return false;
        }
        if (other.partitionKey() == null ^ this.partitionKey() == null) {
            return false;
        }
        return other.partitionKey() == null || other.partitionKey().equals(this.partitionKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.explicitHashKey() != null) {
            sb.append("ExplicitHashKey: ").append(this.explicitHashKey()).append(",");
        }
        if (this.partitionKey() != null) {
            sb.append("PartitionKey: ").append(this.partitionKey()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRecordsRequestEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private ByteBuffer data;
        private String explicitHashKey;
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsRequestEntry model) {
            this.setData(model.data);
            this.setExplicitHashKey(model.explicitHashKey);
            this.setPartitionKey(model.partitionKey);
        }

        public final ByteBuffer getData() {
            return this.data;
        }

        @Override
        public final Builder data(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
            return this;
        }

        public final void setData(ByteBuffer data) {
            this.data = StandardMemberCopier.copy((ByteBuffer)data);
        }

        public final String getExplicitHashKey() {
            return this.explicitHashKey;
        }

        @Override
        public final Builder explicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
            return this;
        }

        public final void setExplicitHashKey(String explicitHashKey) {
            this.explicitHashKey = explicitHashKey;
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public PutRecordsRequestEntry build() {
            return new PutRecordsRequestEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutRecordsRequestEntry> {
        public Builder data(ByteBuffer var1);

        public Builder explicitHashKey(String var1);

        public Builder partitionKey(String var1);
    }
}

