/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;

@SdkInternalApi
public class PutRecordsRequestModelMarshaller {
    private static final MarshallingInfo<List> RECORDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Records").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StreamName").build();
    private static final PutRecordsRequestModelMarshaller instance = new PutRecordsRequestModelMarshaller();

    public static PutRecordsRequestModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(PutRecordsRequest putRecordsRequest, ProtocolMarshaller protocolMarshaller) {
        if (putRecordsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(putRecordsRequest.records(), RECORDS_BINDING);
            protocolMarshaller.marshall((Object)putRecordsRequest.streamName(), STREAMNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

