/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.jmespath.JmesPathEvaluationVisitor;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.jmespath.JmesPathField;
import software.amazon.awssdk.jmespath.JmesPathSubExpression;
import software.amazon.awssdk.jmespath.JmesPathVisitor;
import software.amazon.awssdk.jmespath.ObjectMapperSingleton;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class StreamExists {
    StreamExists() {
    }

    static class IsACTIVEMatcher
    extends WaiterAcceptor<DescribeStreamResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsACTIVEMatcher() {
        }

        public boolean matches(DescribeStreamResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.path((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"ACTIVE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathSubExpression(new JmesPathExpression[]{new JmesPathField("StreamDescription"), new JmesPathField("StreamStatus")});
        }
    }
}

