/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.DestinationSchema;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseOutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsOutputDescription;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutputDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, OutputDescription> {
    private final String outputId;
    private final String name;
    private final KinesisStreamsOutputDescription kinesisStreamsOutputDescription;
    private final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;
    private final DestinationSchema destinationSchema;

    private OutputDescription(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.name = builder.name;
        this.kinesisStreamsOutputDescription = builder.kinesisStreamsOutputDescription;
        this.kinesisFirehoseOutputDescription = builder.kinesisFirehoseOutputDescription;
        this.destinationSchema = builder.destinationSchema;
    }

    public String outputId() {
        return this.outputId;
    }

    public String name() {
        return this.name;
    }

    public KinesisStreamsOutputDescription kinesisStreamsOutputDescription() {
        return this.kinesisStreamsOutputDescription;
    }

    public KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription() {
        return this.kinesisFirehoseOutputDescription;
    }

    public DestinationSchema destinationSchema() {
        return this.destinationSchema;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.outputId() == null ? 0 : this.outputId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.kinesisStreamsOutputDescription() == null ? 0 : this.kinesisStreamsOutputDescription().hashCode());
        hashCode = 31 * hashCode + (this.kinesisFirehoseOutputDescription() == null ? 0 : this.kinesisFirehoseOutputDescription().hashCode());
        hashCode = 31 * hashCode + (this.destinationSchema() == null ? 0 : this.destinationSchema().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDescription)) {
            return false;
        }
        OutputDescription other = (OutputDescription)obj;
        if (other.outputId() == null ^ this.outputId() == null) {
            return false;
        }
        if (other.outputId() != null && !other.outputId().equals(this.outputId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.kinesisStreamsOutputDescription() == null ^ this.kinesisStreamsOutputDescription() == null) {
            return false;
        }
        if (other.kinesisStreamsOutputDescription() != null && !other.kinesisStreamsOutputDescription().equals(this.kinesisStreamsOutputDescription())) {
            return false;
        }
        if (other.kinesisFirehoseOutputDescription() == null ^ this.kinesisFirehoseOutputDescription() == null) {
            return false;
        }
        if (other.kinesisFirehoseOutputDescription() != null && !other.kinesisFirehoseOutputDescription().equals(this.kinesisFirehoseOutputDescription())) {
            return false;
        }
        if (other.destinationSchema() == null ^ this.destinationSchema() == null) {
            return false;
        }
        return other.destinationSchema() == null || other.destinationSchema().equals(this.destinationSchema());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.outputId() != null) {
            sb.append("OutputId: ").append(this.outputId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.kinesisStreamsOutputDescription() != null) {
            sb.append("KinesisStreamsOutputDescription: ").append(this.kinesisStreamsOutputDescription()).append(",");
        }
        if (this.kinesisFirehoseOutputDescription() != null) {
            sb.append("KinesisFirehoseOutputDescription: ").append(this.kinesisFirehoseOutputDescription()).append(",");
        }
        if (this.destinationSchema() != null) {
            sb.append("DestinationSchema: ").append(this.destinationSchema()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String outputId;
        private String name;
        private KinesisStreamsOutputDescription kinesisStreamsOutputDescription;
        private KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;
        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDescription model) {
            this.setOutputId(model.outputId);
            this.setName(model.name);
            this.setKinesisStreamsOutputDescription(model.kinesisStreamsOutputDescription);
            this.setKinesisFirehoseOutputDescription(model.kinesisFirehoseOutputDescription);
            this.setDestinationSchema(model.destinationSchema);
        }

        public final String getOutputId() {
            return this.outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final KinesisStreamsOutputDescription getKinesisStreamsOutputDescription() {
            return this.kinesisStreamsOutputDescription;
        }

        @Override
        public final Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription;
            return this;
        }

        public final void setKinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription;
        }

        public final KinesisFirehoseOutputDescription getKinesisFirehoseOutputDescription() {
            return this.kinesisFirehoseOutputDescription;
        }

        @Override
        public final Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription;
            return this;
        }

        public final void setKinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription;
        }

        public final DestinationSchema getDestinationSchema() {
            return this.destinationSchema;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public final void setDestinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
        }

        public OutputDescription build() {
            return new OutputDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutputDescription> {
        public Builder outputId(String var1);

        public Builder name(String var1);

        public Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription var1);

        public Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription var1);

        public Builder destinationSchema(DestinationSchema var1);
    }
}

