/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.MappingParameters;
import software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordFormatMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecordFormat
implements StructuredPojo,
ToCopyableBuilder<Builder, RecordFormat> {
    private final String recordFormatType;
    private final MappingParameters mappingParameters;

    private RecordFormat(BuilderImpl builder) {
        this.recordFormatType = builder.recordFormatType;
        this.mappingParameters = builder.mappingParameters;
    }

    public String recordFormatType() {
        return this.recordFormatType;
    }

    public MappingParameters mappingParameters() {
        return this.mappingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.recordFormatType() == null ? 0 : this.recordFormatType().hashCode());
        hashCode = 31 * hashCode + (this.mappingParameters() == null ? 0 : this.mappingParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordFormat)) {
            return false;
        }
        RecordFormat other = (RecordFormat)obj;
        if (other.recordFormatType() == null ^ this.recordFormatType() == null) {
            return false;
        }
        if (other.recordFormatType() != null && !other.recordFormatType().equals(this.recordFormatType())) {
            return false;
        }
        if (other.mappingParameters() == null ^ this.mappingParameters() == null) {
            return false;
        }
        return other.mappingParameters() == null || other.mappingParameters().equals(this.mappingParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.recordFormatType() != null) {
            sb.append("RecordFormatType: ").append(this.recordFormatType()).append(",");
        }
        if (this.mappingParameters() != null) {
            sb.append("MappingParameters: ").append(this.mappingParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecordFormatMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String recordFormatType;
        private MappingParameters mappingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordFormat model) {
            this.setRecordFormatType(model.recordFormatType);
            this.setMappingParameters(model.mappingParameters);
        }

        public final String getRecordFormatType() {
            return this.recordFormatType;
        }

        @Override
        public final Builder recordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
            return this;
        }

        @Override
        public final Builder recordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
            return this;
        }

        public final void setRecordFormatType(String recordFormatType) {
            this.recordFormatType = recordFormatType;
        }

        public final void setRecordFormatType(RecordFormatType recordFormatType) {
            this.recordFormatType(recordFormatType.toString());
        }

        public final MappingParameters getMappingParameters() {
            return this.mappingParameters;
        }

        @Override
        public final Builder mappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
            return this;
        }

        public final void setMappingParameters(MappingParameters mappingParameters) {
            this.mappingParameters = mappingParameters;
        }

        public RecordFormat build() {
            return new RecordFormat(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecordFormat> {
        public Builder recordFormatType(String var1);

        public Builder recordFormatType(RecordFormatType var1);

        public Builder mappingParameters(MappingParameters var1);
    }
}

