/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.ReferenceDataSourceUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReferenceDataSourceUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, ReferenceDataSourceUpdate> {
    private final String referenceId;
    private final String tableNameUpdate;
    private final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;
    private final SourceSchema referenceSchemaUpdate;

    private ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableNameUpdate = builder.tableNameUpdate;
        this.s3ReferenceDataSourceUpdate = builder.s3ReferenceDataSourceUpdate;
        this.referenceSchemaUpdate = builder.referenceSchemaUpdate;
    }

    public String referenceId() {
        return this.referenceId;
    }

    public String tableNameUpdate() {
        return this.tableNameUpdate;
    }

    public S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate() {
        return this.s3ReferenceDataSourceUpdate;
    }

    public SourceSchema referenceSchemaUpdate() {
        return this.referenceSchemaUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.referenceId() == null ? 0 : this.referenceId().hashCode());
        hashCode = 31 * hashCode + (this.tableNameUpdate() == null ? 0 : this.tableNameUpdate().hashCode());
        hashCode = 31 * hashCode + (this.s3ReferenceDataSourceUpdate() == null ? 0 : this.s3ReferenceDataSourceUpdate().hashCode());
        hashCode = 31 * hashCode + (this.referenceSchemaUpdate() == null ? 0 : this.referenceSchemaUpdate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceUpdate)) {
            return false;
        }
        ReferenceDataSourceUpdate other = (ReferenceDataSourceUpdate)obj;
        if (other.referenceId() == null ^ this.referenceId() == null) {
            return false;
        }
        if (other.referenceId() != null && !other.referenceId().equals(this.referenceId())) {
            return false;
        }
        if (other.tableNameUpdate() == null ^ this.tableNameUpdate() == null) {
            return false;
        }
        if (other.tableNameUpdate() != null && !other.tableNameUpdate().equals(this.tableNameUpdate())) {
            return false;
        }
        if (other.s3ReferenceDataSourceUpdate() == null ^ this.s3ReferenceDataSourceUpdate() == null) {
            return false;
        }
        if (other.s3ReferenceDataSourceUpdate() != null && !other.s3ReferenceDataSourceUpdate().equals(this.s3ReferenceDataSourceUpdate())) {
            return false;
        }
        if (other.referenceSchemaUpdate() == null ^ this.referenceSchemaUpdate() == null) {
            return false;
        }
        return other.referenceSchemaUpdate() == null || other.referenceSchemaUpdate().equals(this.referenceSchemaUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.referenceId() != null) {
            sb.append("ReferenceId: ").append(this.referenceId()).append(",");
        }
        if (this.tableNameUpdate() != null) {
            sb.append("TableNameUpdate: ").append(this.tableNameUpdate()).append(",");
        }
        if (this.s3ReferenceDataSourceUpdate() != null) {
            sb.append("S3ReferenceDataSourceUpdate: ").append(this.s3ReferenceDataSourceUpdate()).append(",");
        }
        if (this.referenceSchemaUpdate() != null) {
            sb.append("ReferenceSchemaUpdate: ").append(this.referenceSchemaUpdate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReferenceDataSourceUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String referenceId;
        private String tableNameUpdate;
        private S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;
        private SourceSchema referenceSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceUpdate model) {
            this.setReferenceId(model.referenceId);
            this.setTableNameUpdate(model.tableNameUpdate);
            this.setS3ReferenceDataSourceUpdate(model.s3ReferenceDataSourceUpdate);
            this.setReferenceSchemaUpdate(model.referenceSchemaUpdate);
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        public final String getTableNameUpdate() {
            return this.tableNameUpdate;
        }

        @Override
        public final Builder tableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
            return this;
        }

        public final void setTableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
        }

        public final S3ReferenceDataSourceUpdate getS3ReferenceDataSourceUpdate() {
            return this.s3ReferenceDataSourceUpdate;
        }

        @Override
        public final Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
            return this;
        }

        public final void setS3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
        }

        public final SourceSchema getReferenceSchemaUpdate() {
            return this.referenceSchemaUpdate;
        }

        @Override
        public final Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
            return this;
        }

        public final void setReferenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
        }

        public ReferenceDataSourceUpdate build() {
            return new ReferenceDataSourceUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReferenceDataSourceUpdate> {
        public Builder referenceId(String var1);

        public Builder tableNameUpdate(String var1);

        public Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate var1);

        public Builder referenceSchemaUpdate(SourceSchema var1);
    }
}

