/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.InputConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.model.InputConfigurationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartApplicationRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StartApplicationRequest> {
    private final String applicationName;
    private final List<InputConfiguration> inputConfigurations;

    private StartApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.inputConfigurations = builder.inputConfigurations;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public List<InputConfiguration> inputConfigurations() {
        return this.inputConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationName() == null ? 0 : this.applicationName().hashCode());
        hashCode = 31 * hashCode + (this.inputConfigurations() == null ? 0 : this.inputConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest)((Object)obj);
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.inputConfigurations() == null ^ this.inputConfigurations() == null) {
            return false;
        }
        return other.inputConfigurations() == null || other.inputConfigurations().equals(this.inputConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.inputConfigurations() != null) {
            sb.append("InputConfigurations: ").append(this.inputConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private List<InputConfiguration> inputConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(StartApplicationRequest model) {
            this.setApplicationName(model.applicationName);
            this.setInputConfigurations(model.inputConfigurations);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<InputConfiguration> getInputConfigurations() {
            return this.inputConfigurations;
        }

        @Override
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration ... inputConfigurations) {
            if (this.inputConfigurations == null) {
                this.inputConfigurations = new ArrayList<InputConfiguration>(inputConfigurations.length);
            }
            for (InputConfiguration e : inputConfigurations) {
                this.inputConfigurations.add(e);
            }
            return this;
        }

        public final void setInputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
        }

        @SafeVarargs
        public final void setInputConfigurations(InputConfiguration ... inputConfigurations) {
            if (this.inputConfigurations == null) {
                this.inputConfigurations = new ArrayList<InputConfiguration>(inputConfigurations.length);
            }
            for (InputConfiguration e : inputConfigurations) {
                this.inputConfigurations.add(e);
            }
        }

        public StartApplicationRequest build() {
            return new StartApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StartApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder inputConfigurations(Collection<InputConfiguration> var1);

        public Builder inputConfigurations(InputConfiguration ... var1);
    }
}

