/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSource;

public class S3ReferenceDataSourceUnmarshaller
implements Unmarshaller<S3ReferenceDataSource, JsonUnmarshallerContext> {
    private static S3ReferenceDataSourceUnmarshaller INSTANCE;

    public S3ReferenceDataSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3ReferenceDataSource.Builder s3ReferenceDataSourceBuilder = S3ReferenceDataSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BucketARN", targetDepth)) {
                    context.nextToken();
                    s3ReferenceDataSourceBuilder.bucketARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FileKey", targetDepth)) {
                    context.nextToken();
                    s3ReferenceDataSourceBuilder.fileKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ReferenceRoleARN", targetDepth)) {
                    context.nextToken();
                    s3ReferenceDataSourceBuilder.referenceRoleARN((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (S3ReferenceDataSource)s3ReferenceDataSourceBuilder.build();
    }

    public static S3ReferenceDataSourceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3ReferenceDataSourceUnmarshaller();
        }
        return INSTANCE;
    }
}

