/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordColumnUnmarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.RecordFormatUnmarshaller;

public class SourceSchemaUnmarshaller
implements Unmarshaller<SourceSchema, JsonUnmarshallerContext> {
    private static SourceSchemaUnmarshaller INSTANCE;

    public SourceSchema unmarshall(JsonUnmarshallerContext context) throws Exception {
        SourceSchema.Builder sourceSchemaBuilder = SourceSchema.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RecordFormat", targetDepth)) {
                    context.nextToken();
                    sourceSchemaBuilder.recordFormat(RecordFormatUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RecordEncoding", targetDepth)) {
                    context.nextToken();
                    sourceSchemaBuilder.recordEncoding((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RecordColumns", targetDepth)) {
                    context.nextToken();
                    sourceSchemaBuilder.recordColumns(new ListUnmarshaller((Unmarshaller)RecordColumnUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SourceSchema)sourceSchemaBuilder.build();
    }

    public static SourceSchemaUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SourceSchemaUnmarshaller();
        }
        return INSTANCE;
    }
}

