/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ElasticsearchDestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The destination description in Amazon ES.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticsearchDestinationDescription implements StructuredPojo,
        ToCopyableBuilder<ElasticsearchDestinationDescription.Builder, ElasticsearchDestinationDescription> {
    private final String roleARN;

    private final String domainARN;

    private final String indexName;

    private final String typeName;

    private final String indexRotationPeriod;

    private final ElasticsearchBufferingHints bufferingHints;

    private final ElasticsearchRetryOptions retryOptions;

    private final String s3BackupMode;

    private final S3DestinationDescription s3DestinationDescription;

    private final ProcessingConfiguration processingConfiguration;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private ElasticsearchDestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.domainARN = builder.domainARN;
        this.indexName = builder.indexName;
        this.typeName = builder.typeName;
        this.indexRotationPeriod = builder.indexRotationPeriod;
        this.bufferingHints = builder.bufferingHints;
        this.retryOptions = builder.retryOptions;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.processingConfiguration = builder.processingConfiguration;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the AWS credentials.
     * </p>
     * 
     * @return The ARN of the AWS credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The ARN of the Amazon ES domain.
     * </p>
     * 
     * @return The ARN of the Amazon ES domain.
     */
    public String domainARN() {
        return domainARN;
    }

    /**
     * <p>
     * The Elasticsearch index name.
     * </p>
     * 
     * @return The Elasticsearch index name.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * The Elasticsearch type name.
     * </p>
     * 
     * @return The Elasticsearch type name.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The Elasticsearch index rotation period
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period
     * @see ElasticsearchIndexRotationPeriod
     */
    public ElasticsearchIndexRotationPeriod indexRotationPeriod() {
        return ElasticsearchIndexRotationPeriod.fromValue(indexRotationPeriod);
    }

    /**
     * <p>
     * The Elasticsearch index rotation period
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #indexRotationPeriod} will return {@link ElasticsearchIndexRotationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #indexRotationPeriodAsString}.
     * </p>
     * 
     * @return The Elasticsearch index rotation period
     * @see ElasticsearchIndexRotationPeriod
     */
    public String indexRotationPeriodAsString() {
        return indexRotationPeriod;
    }

    /**
     * <p>
     * The buffering options.
     * </p>
     * 
     * @return The buffering options.
     */
    public ElasticsearchBufferingHints bufferingHints() {
        return bufferingHints;
    }

    /**
     * <p>
     * The Amazon ES retry options.
     * </p>
     * 
     * @return The Amazon ES retry options.
     */
    public ElasticsearchRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link ElasticsearchS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see ElasticsearchS3BackupMode
     */
    public ElasticsearchS3BackupMode s3BackupMode() {
        return ElasticsearchS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link ElasticsearchS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see ElasticsearchS3BackupMode
     */
    public String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * <p>
     * The Amazon S3 destination.
     * </p>
     * 
     * @return The Amazon S3 destination.
     */
    public S3DestinationDescription s3DestinationDescription() {
        return s3DestinationDescription;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The CloudWatch logging options.
     * </p>
     * 
     * @return The CloudWatch logging options.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(domainARN());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(indexRotationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bufferingHints());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchDestinationDescription)) {
            return false;
        }
        ElasticsearchDestinationDescription other = (ElasticsearchDestinationDescription) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(domainARN(), other.domainARN())
                && Objects.equals(indexName(), other.indexName()) && Objects.equals(typeName(), other.typeName())
                && Objects.equals(indexRotationPeriodAsString(), other.indexRotationPeriodAsString())
                && Objects.equals(bufferingHints(), other.bufferingHints())
                && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3DestinationDescription(), other.s3DestinationDescription())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("ElasticsearchDestinationDescription").add("RoleARN", roleARN()).add("DomainARN", domainARN())
                .add("IndexName", indexName()).add("TypeName", typeName())
                .add("IndexRotationPeriod", indexRotationPeriodAsString()).add("BufferingHints", bufferingHints())
                .add("RetryOptions", retryOptions()).add("S3BackupMode", s3BackupModeAsString())
                .add("S3DestinationDescription", s3DestinationDescription())
                .add("ProcessingConfiguration", processingConfiguration())
                .add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "DomainARN":
            return Optional.of(clazz.cast(domainARN()));
        case "IndexName":
            return Optional.of(clazz.cast(indexName()));
        case "TypeName":
            return Optional.of(clazz.cast(typeName()));
        case "IndexRotationPeriod":
            return Optional.of(clazz.cast(indexRotationPeriodAsString()));
        case "BufferingHints":
            return Optional.of(clazz.cast(bufferingHints()));
        case "RetryOptions":
            return Optional.of(clazz.cast(retryOptions()));
        case "S3BackupMode":
            return Optional.of(clazz.cast(s3BackupModeAsString()));
        case "S3DestinationDescription":
            return Optional.of(clazz.cast(s3DestinationDescription()));
        case "ProcessingConfiguration":
            return Optional.of(clazz.cast(processingConfiguration()));
        case "CloudWatchLoggingOptions":
            return Optional.of(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticsearchDestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticsearchDestinationDescription> {
        /**
         * <p>
         * The ARN of the AWS credentials.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the AWS credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The ARN of the Amazon ES domain.
         * </p>
         * 
         * @param domainARN
         *        The ARN of the Amazon ES domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainARN(String domainARN);

        /**
         * <p>
         * The Elasticsearch index name.
         * </p>
         * 
         * @param indexName
         *        The Elasticsearch index name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * The Elasticsearch type name.
         * </p>
         * 
         * @param typeName
         *        The Elasticsearch type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The Elasticsearch index rotation period
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(String indexRotationPeriod);

        /**
         * <p>
         * The Elasticsearch index rotation period
         * </p>
         * 
         * @param indexRotationPeriod
         *        The Elasticsearch index rotation period
         * @see ElasticsearchIndexRotationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchIndexRotationPeriod
         */
        Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod);

        /**
         * <p>
         * The buffering options.
         * </p>
         * 
         * @param bufferingHints
         *        The buffering options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferingHints(ElasticsearchBufferingHints bufferingHints);

        /**
         * <p>
         * The buffering options.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchBufferingHints.Builder} avoiding
         * the need to create one manually via {@link ElasticsearchBufferingHints#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchBufferingHints.Builder#build()} is called
         * immediately and its result is passed to {@link #bufferingHints(ElasticsearchBufferingHints)}.
         * 
         * @param bufferingHints
         *        a consumer that will call methods on {@link ElasticsearchBufferingHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bufferingHints(ElasticsearchBufferingHints)
         */
        default Builder bufferingHints(Consumer<ElasticsearchBufferingHints.Builder> bufferingHints) {
            return bufferingHints(ElasticsearchBufferingHints.builder().apply(bufferingHints).build());
        }

        /**
         * <p>
         * The Amazon ES retry options.
         * </p>
         * 
         * @param retryOptions
         *        The Amazon ES retry options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(ElasticsearchRetryOptions retryOptions);

        /**
         * <p>
         * The Amazon ES retry options.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchRetryOptions.Builder} avoiding the
         * need to create one manually via {@link ElasticsearchRetryOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchRetryOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #retryOptions(ElasticsearchRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link ElasticsearchRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(ElasticsearchRetryOptions)
         */
        default Builder retryOptions(Consumer<ElasticsearchRetryOptions.Builder> retryOptions) {
            return retryOptions(ElasticsearchRetryOptions.builder().apply(retryOptions).build());
        }

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see ElasticsearchS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see ElasticsearchS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticsearchS3BackupMode
         */
        Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode);

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * 
         * @param s3DestinationDescription
         *        The Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription);

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationDescription.Builder} avoiding the
         * need to create one manually via {@link S3DestinationDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DestinationDescription(S3DestinationDescription)}.
         * 
         * @param s3DestinationDescription
         *        a consumer that will call methods on {@link S3DestinationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationDescription(S3DestinationDescription)
         */
        default Builder s3DestinationDescription(Consumer<S3DestinationDescription.Builder> s3DestinationDescription) {
            return s3DestinationDescription(S3DestinationDescription.builder().apply(s3DestinationDescription).build());
        }

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().apply(processingConfiguration).build());
        }

        /**
         * <p>
         * The CloudWatch logging options.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The CloudWatch logging options.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String domainARN;

        private String indexName;

        private String typeName;

        private String indexRotationPeriod;

        private ElasticsearchBufferingHints bufferingHints;

        private ElasticsearchRetryOptions retryOptions;

        private String s3BackupMode;

        private S3DestinationDescription s3DestinationDescription;

        private ProcessingConfiguration processingConfiguration;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchDestinationDescription model) {
            roleARN(model.roleARN);
            domainARN(model.domainARN);
            indexName(model.indexName);
            typeName(model.typeName);
            indexRotationPeriod(model.indexRotationPeriod);
            bufferingHints(model.bufferingHints);
            retryOptions(model.retryOptions);
            s3BackupMode(model.s3BackupMode);
            s3DestinationDescription(model.s3DestinationDescription);
            processingConfiguration(model.processingConfiguration);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getDomainARN() {
            return domainARN;
        }

        @Override
        public final Builder domainARN(String domainARN) {
            this.domainARN = domainARN;
            return this;
        }

        public final void setDomainARN(String domainARN) {
            this.domainARN = domainARN;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getIndexRotationPeriod() {
            return indexRotationPeriod;
        }

        @Override
        public final Builder indexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
            return this;
        }

        @Override
        public final Builder indexRotationPeriod(ElasticsearchIndexRotationPeriod indexRotationPeriod) {
            this.indexRotationPeriod(indexRotationPeriod.toString());
            return this;
        }

        public final void setIndexRotationPeriod(String indexRotationPeriod) {
            this.indexRotationPeriod = indexRotationPeriod;
        }

        public final ElasticsearchBufferingHints.Builder getBufferingHints() {
            return bufferingHints != null ? bufferingHints.toBuilder() : null;
        }

        @Override
        public final Builder bufferingHints(ElasticsearchBufferingHints bufferingHints) {
            this.bufferingHints = bufferingHints;
            return this;
        }

        public final void setBufferingHints(ElasticsearchBufferingHints.BuilderImpl bufferingHints) {
            this.bufferingHints = bufferingHints != null ? bufferingHints.build() : null;
        }

        public final ElasticsearchRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(ElasticsearchRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(ElasticsearchRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(ElasticsearchS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationDescription.Builder getS3DestinationDescription() {
            return s3DestinationDescription != null ? s3DestinationDescription.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription.BuilderImpl s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription != null ? s3DestinationDescription.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public ElasticsearchDestinationDescription build() {
            return new ElasticsearchDestinationDescription(this);
        }
    }
}
