/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordRequest extends FirehoseRequest implements ToCopyableBuilder<PutRecordRequest.Builder, PutRecordRequest> {
    private final String deliveryStreamName;

    private final Record record;

    private PutRecordRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryStreamName = builder.deliveryStreamName;
        this.record = builder.record;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * The record.
     * </p>
     * 
     * @return The record.
     */
    public Record record() {
        return record;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(record());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordRequest)) {
            return false;
        }
        PutRecordRequest other = (PutRecordRequest) obj;
        return Objects.equals(deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(record(), other.record());
    }

    @Override
    public String toString() {
        return ToString.builder("PutRecordRequest").add("DeliveryStreamName", deliveryStreamName()).add("Record", record())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        case "Record":
            return Optional.of(clazz.cast(record()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends FirehoseRequest.Builder, CopyableBuilder<Builder, PutRecordRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * The record.
         * </p>
         * 
         * @param record
         *        The record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder record(Record record);

        /**
         * <p>
         * The record.
         * </p>
         * This is a convenience that creates an instance of the {@link Record.Builder} avoiding the need to create one
         * manually via {@link Record#builder()}.
         *
         * When the {@link Consumer} completes, {@link Record.Builder#build()} is called immediately and its result is
         * passed to {@link #record(Record)}.
         * 
         * @param record
         *        a consumer that will call methods on {@link Record.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #record(Record)
         */
        default Builder record(Consumer<Record.Builder> record) {
            return record(Record.builder().apply(record).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FirehoseRequest.BuilderImpl implements Builder {
        private String deliveryStreamName;

        private Record record;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordRequest model) {
            super(model);
            deliveryStreamName(model.deliveryStreamName);
            record(model.record);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Record.Builder getRecord() {
            return record != null ? record.toBuilder() : null;
        }

        @Override
        public final Builder record(Record record) {
            this.record = record;
            return this;
        }

        public final void setRecord(Record.BuilderImpl record) {
            this.record = record != null ? record.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutRecordRequest build() {
            return new PutRecordRequest(this);
        }
    }
}
