/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.RedshiftDestinationUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an update for a destination in Amazon Redshift.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RedshiftDestinationUpdate implements StructuredPojo,
        ToCopyableBuilder<RedshiftDestinationUpdate.Builder, RedshiftDestinationUpdate> {
    private final String roleARN;

    private final String clusterJDBCURL;

    private final CopyCommand copyCommand;

    private final String username;

    private final String password;

    private final RedshiftRetryOptions retryOptions;

    private final S3DestinationUpdate s3Update;

    private final ProcessingConfiguration processingConfiguration;

    private final String s3BackupMode;

    private final S3DestinationUpdate s3BackupUpdate;

    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private RedshiftDestinationUpdate(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.clusterJDBCURL = builder.clusterJDBCURL;
        this.copyCommand = builder.copyCommand;
        this.username = builder.username;
        this.password = builder.password;
        this.retryOptions = builder.retryOptions;
        this.s3Update = builder.s3Update;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupUpdate = builder.s3BackupUpdate;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * The ARN of the AWS credentials.
     * </p>
     * 
     * @return The ARN of the AWS credentials.
     */
    public String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * The database connection string.
     * </p>
     * 
     * @return The database connection string.
     */
    public String clusterJDBCURL() {
        return clusterJDBCURL;
    }

    /**
     * <p>
     * The <code>COPY</code> command.
     * </p>
     * 
     * @return The <code>COPY</code> command.
     */
    public CopyCommand copyCommand() {
        return copyCommand;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */
    public String username() {
        return username;
    }

    /**
     * <p>
     * The user password.
     * </p>
     * 
     * @return The user password.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default value is
     * 3600 (60 minutes).
     * </p>
     * 
     * @return The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default
     *         value is 3600 (60 minutes).
     */
    public RedshiftRetryOptions retryOptions() {
        return retryOptions;
    }

    /**
     * <p>
     * The Amazon S3 destination.
     * </p>
     * <p>
     * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in
     * <b>RedshiftDestinationUpdate.S3Update</b> because the Amazon Redshift <code>COPY</code> operation that reads from
     * the S3 bucket doesn't support these compression formats.
     * </p>
     * 
     * @return The Amazon S3 destination.</p>
     *         <p>
     *         The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in
     *         <b>RedshiftDestinationUpdate.S3Update</b> because the Amazon Redshift <code>COPY</code> operation that
     *         reads from the S3 bucket doesn't support these compression formats.
     */
    public S3DestinationUpdate s3Update() {
        return s3Update;
    }

    /**
     * <p>
     * The data processing configuration.
     * </p>
     * 
     * @return The data processing configuration.
     */
    public ProcessingConfiguration processingConfiguration() {
        return processingConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link RedshiftS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see RedshiftS3BackupMode
     */
    public RedshiftS3BackupMode s3BackupMode() {
        return RedshiftS3BackupMode.fromValue(s3BackupMode);
    }

    /**
     * <p>
     * The Amazon S3 backup mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3BackupMode} will
     * return {@link RedshiftS3BackupMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #s3BackupModeAsString}.
     * </p>
     * 
     * @return The Amazon S3 backup mode.
     * @see RedshiftS3BackupMode
     */
    public String s3BackupModeAsString() {
        return s3BackupMode;
    }

    /**
     * <p>
     * The Amazon S3 destination for backup.
     * </p>
     * 
     * @return The Amazon S3 destination for backup.
     */
    public S3DestinationUpdate s3BackupUpdate() {
        return s3BackupUpdate;
    }

    /**
     * <p>
     * The CloudWatch logging options for your delivery stream.
     * </p>
     * 
     * @return The CloudWatch logging options for your delivery stream.
     */
    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(clusterJDBCURL());
        hashCode = 31 * hashCode + Objects.hashCode(copyCommand());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(retryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(s3Update());
        hashCode = 31 * hashCode + Objects.hashCode(processingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3BackupUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDestinationUpdate)) {
            return false;
        }
        RedshiftDestinationUpdate other = (RedshiftDestinationUpdate) obj;
        return Objects.equals(roleARN(), other.roleARN()) && Objects.equals(clusterJDBCURL(), other.clusterJDBCURL())
                && Objects.equals(copyCommand(), other.copyCommand()) && Objects.equals(username(), other.username())
                && Objects.equals(password(), other.password()) && Objects.equals(retryOptions(), other.retryOptions())
                && Objects.equals(s3Update(), other.s3Update())
                && Objects.equals(processingConfiguration(), other.processingConfiguration())
                && Objects.equals(s3BackupModeAsString(), other.s3BackupModeAsString())
                && Objects.equals(s3BackupUpdate(), other.s3BackupUpdate())
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("RedshiftDestinationUpdate").add("RoleARN", roleARN()).add("ClusterJDBCURL", clusterJDBCURL())
                .add("CopyCommand", copyCommand()).add("Username", username()).add("Password", password())
                .add("RetryOptions", retryOptions()).add("S3Update", s3Update())
                .add("ProcessingConfiguration", processingConfiguration()).add("S3BackupMode", s3BackupModeAsString())
                .add("S3BackupUpdate", s3BackupUpdate()).add("CloudWatchLoggingOptions", cloudWatchLoggingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoleARN":
            return Optional.of(clazz.cast(roleARN()));
        case "ClusterJDBCURL":
            return Optional.of(clazz.cast(clusterJDBCURL()));
        case "CopyCommand":
            return Optional.of(clazz.cast(copyCommand()));
        case "Username":
            return Optional.of(clazz.cast(username()));
        case "Password":
            return Optional.of(clazz.cast(password()));
        case "RetryOptions":
            return Optional.of(clazz.cast(retryOptions()));
        case "S3Update":
            return Optional.of(clazz.cast(s3Update()));
        case "ProcessingConfiguration":
            return Optional.of(clazz.cast(processingConfiguration()));
        case "S3BackupMode":
            return Optional.of(clazz.cast(s3BackupModeAsString()));
        case "S3BackupUpdate":
            return Optional.of(clazz.cast(s3BackupUpdate()));
        case "CloudWatchLoggingOptions":
            return Optional.of(clazz.cast(cloudWatchLoggingOptions()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDestinationUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RedshiftDestinationUpdate> {
        /**
         * <p>
         * The ARN of the AWS credentials.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the AWS credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * The database connection string.
         * </p>
         * 
         * @param clusterJDBCURL
         *        The database connection string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterJDBCURL(String clusterJDBCURL);

        /**
         * <p>
         * The <code>COPY</code> command.
         * </p>
         * 
         * @param copyCommand
         *        The <code>COPY</code> command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyCommand(CopyCommand copyCommand);

        /**
         * <p>
         * The <code>COPY</code> command.
         * </p>
         * This is a convenience that creates an instance of the {@link CopyCommand.Builder} avoiding the need to create
         * one manually via {@link CopyCommand#builder()}.
         *
         * When the {@link Consumer} completes, {@link CopyCommand.Builder#build()} is called immediately and its result
         * is passed to {@link #copyCommand(CopyCommand)}.
         * 
         * @param copyCommand
         *        a consumer that will call methods on {@link CopyCommand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #copyCommand(CopyCommand)
         */
        default Builder copyCommand(Consumer<CopyCommand.Builder> copyCommand) {
            return copyCommand(CopyCommand.builder().apply(copyCommand).build());
        }

        /**
         * <p>
         * The name of the user.
         * </p>
         * 
         * @param username
         *        The name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The user password.
         * </p>
         * 
         * @param password
         *        The user password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default value
         * is 3600 (60 minutes).
         * </p>
         * 
         * @param retryOptions
         *        The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default
         *        value is 3600 (60 minutes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryOptions(RedshiftRetryOptions retryOptions);

        /**
         * <p>
         * The retry behavior in case Kinesis Firehose is unable to deliver documents to Amazon Redshift. Default value
         * is 3600 (60 minutes).
         * </p>
         * This is a convenience that creates an instance of the {@link RedshiftRetryOptions.Builder} avoiding the need
         * to create one manually via {@link RedshiftRetryOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link RedshiftRetryOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #retryOptions(RedshiftRetryOptions)}.
         * 
         * @param retryOptions
         *        a consumer that will call methods on {@link RedshiftRetryOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retryOptions(RedshiftRetryOptions)
         */
        default Builder retryOptions(Consumer<RedshiftRetryOptions.Builder> retryOptions) {
            return retryOptions(RedshiftRetryOptions.builder().apply(retryOptions).build());
        }

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * <p>
         * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in
         * <b>RedshiftDestinationUpdate.S3Update</b> because the Amazon Redshift <code>COPY</code> operation that reads
         * from the S3 bucket doesn't support these compression formats.
         * </p>
         * 
         * @param s3Update
         *        The Amazon S3 destination.</p>
         *        <p>
         *        The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in
         *        <b>RedshiftDestinationUpdate.S3Update</b> because the Amazon Redshift <code>COPY</code> operation that
         *        reads from the S3 bucket doesn't support these compression formats.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Update(S3DestinationUpdate s3Update);

        /**
         * <p>
         * The Amazon S3 destination.
         * </p>
         * <p>
         * The compression formats <code>SNAPPY</code> or <code>ZIP</code> cannot be specified in
         * <b>RedshiftDestinationUpdate.S3Update</b> because the Amazon Redshift <code>COPY</code> operation that reads
         * from the S3 bucket doesn't support these compression formats.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationUpdate.Builder} avoiding the need
         * to create one manually via {@link S3DestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Update(S3DestinationUpdate)}.
         * 
         * @param s3Update
         *        a consumer that will call methods on {@link S3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Update(S3DestinationUpdate)
         */
        default Builder s3Update(Consumer<S3DestinationUpdate.Builder> s3Update) {
            return s3Update(S3DestinationUpdate.builder().apply(s3Update).build());
        }

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * 
         * @param processingConfiguration
         *        The data processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingConfiguration(ProcessingConfiguration processingConfiguration);

        /**
         * <p>
         * The data processing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ProcessingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ProcessingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProcessingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #processingConfiguration(ProcessingConfiguration)}.
         * 
         * @param processingConfiguration
         *        a consumer that will call methods on {@link ProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingConfiguration(ProcessingConfiguration)
         */
        default Builder processingConfiguration(Consumer<ProcessingConfiguration.Builder> processingConfiguration) {
            return processingConfiguration(ProcessingConfiguration.builder().apply(processingConfiguration).build());
        }

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see RedshiftS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftS3BackupMode
         */
        Builder s3BackupMode(String s3BackupMode);

        /**
         * <p>
         * The Amazon S3 backup mode.
         * </p>
         * 
         * @param s3BackupMode
         *        The Amazon S3 backup mode.
         * @see RedshiftS3BackupMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedshiftS3BackupMode
         */
        Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode);

        /**
         * <p>
         * The Amazon S3 destination for backup.
         * </p>
         * 
         * @param s3BackupUpdate
         *        The Amazon S3 destination for backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BackupUpdate(S3DestinationUpdate s3BackupUpdate);

        /**
         * <p>
         * The Amazon S3 destination for backup.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationUpdate.Builder} avoiding the need
         * to create one manually via {@link S3DestinationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationUpdate.Builder#build()} is called immediately and
         * its result is passed to {@link #s3BackupUpdate(S3DestinationUpdate)}.
         * 
         * @param s3BackupUpdate
         *        a consumer that will call methods on {@link S3DestinationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3BackupUpdate(S3DestinationUpdate)
         */
        default Builder s3BackupUpdate(Consumer<S3DestinationUpdate.Builder> s3BackupUpdate) {
            return s3BackupUpdate(S3DestinationUpdate.builder().apply(s3BackupUpdate).build());
        }

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        The CloudWatch logging options for your delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions);

        /**
         * <p>
         * The CloudWatch logging options for your delivery stream.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOptions.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOptions(CloudWatchLoggingOptions)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link CloudWatchLoggingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(CloudWatchLoggingOptions)
         */
        default Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOptions.Builder> cloudWatchLoggingOptions) {
            return cloudWatchLoggingOptions(CloudWatchLoggingOptions.builder().apply(cloudWatchLoggingOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String roleARN;

        private String clusterJDBCURL;

        private CopyCommand copyCommand;

        private String username;

        private String password;

        private RedshiftRetryOptions retryOptions;

        private S3DestinationUpdate s3Update;

        private ProcessingConfiguration processingConfiguration;

        private String s3BackupMode;

        private S3DestinationUpdate s3BackupUpdate;

        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDestinationUpdate model) {
            roleARN(model.roleARN);
            clusterJDBCURL(model.clusterJDBCURL);
            copyCommand(model.copyCommand);
            username(model.username);
            password(model.password);
            retryOptions(model.retryOptions);
            s3Update(model.s3Update);
            processingConfiguration(model.processingConfiguration);
            s3BackupMode(model.s3BackupMode);
            s3BackupUpdate(model.s3BackupUpdate);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterJDBCURL() {
            return clusterJDBCURL;
        }

        @Override
        public final Builder clusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
            return this;
        }

        public final void setClusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
        }

        public final CopyCommand.Builder getCopyCommand() {
            return copyCommand != null ? copyCommand.toBuilder() : null;
        }

        @Override
        public final Builder copyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
            return this;
        }

        public final void setCopyCommand(CopyCommand.BuilderImpl copyCommand) {
            this.copyCommand = copyCommand != null ? copyCommand.build() : null;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final RedshiftRetryOptions.Builder getRetryOptions() {
            return retryOptions != null ? retryOptions.toBuilder() : null;
        }

        @Override
        public final Builder retryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(RedshiftRetryOptions.BuilderImpl retryOptions) {
            this.retryOptions = retryOptions != null ? retryOptions.build() : null;
        }

        public final S3DestinationUpdate.Builder getS3Update() {
            return s3Update != null ? s3Update.toBuilder() : null;
        }

        @Override
        public final Builder s3Update(S3DestinationUpdate s3Update) {
            this.s3Update = s3Update;
            return this;
        }

        public final void setS3Update(S3DestinationUpdate.BuilderImpl s3Update) {
            this.s3Update = s3Update != null ? s3Update.build() : null;
        }

        public final ProcessingConfiguration.Builder getProcessingConfiguration() {
            return processingConfiguration != null ? processingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration.BuilderImpl processingConfiguration) {
            this.processingConfiguration = processingConfiguration != null ? processingConfiguration.build() : null;
        }

        public final String getS3BackupMode() {
            return s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationUpdate.Builder getS3BackupUpdate() {
            return s3BackupUpdate != null ? s3BackupUpdate.toBuilder() : null;
        }

        @Override
        public final Builder s3BackupUpdate(S3DestinationUpdate s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate;
            return this;
        }

        public final void setS3BackupUpdate(S3DestinationUpdate.BuilderImpl s3BackupUpdate) {
            this.s3BackupUpdate = s3BackupUpdate != null ? s3BackupUpdate.build() : null;
        }

        public final CloudWatchLoggingOptions.Builder getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions.BuilderImpl cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions != null ? cloudWatchLoggingOptions.build() : null;
        }

        @Override
        public RedshiftDestinationUpdate build() {
            return new RedshiftDestinationUpdate(this);
        }
    }
}
