/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.firehose.model.CopyCommand;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link CopyCommand} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CopyCommandMarshaller {
    private static final MarshallingInfo<String> DATATABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableName").isBinary(false).build();

    private static final MarshallingInfo<String> DATATABLECOLUMNS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataTableColumns").isBinary(false).build();

    private static final MarshallingInfo<String> COPYOPTIONS_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyOptions").isBinary(false).build();

    private static final CopyCommandMarshaller INSTANCE = new CopyCommandMarshaller();

    private CopyCommandMarshaller() {
    }

    public static CopyCommandMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(CopyCommand copyCommand, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(copyCommand, "copyCommand");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(copyCommand.dataTableName(), DATATABLENAME_BINDING);
            protocolMarshaller.marshall(copyCommand.dataTableColumns(), DATATABLECOLUMNS_BINDING);
            protocolMarshaller.marshall(copyCommand.copyOptions(), COPYOPTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
