/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.RedshiftDestinationConfiguration;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link RedshiftDestinationConfiguration} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class RedshiftDestinationConfigurationMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleARN").isBinary(false).build();

    private static final MarshallingInfo<String> CLUSTERJDBCURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterJDBCURL").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> COPYCOMMAND_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyCommand")
            .isBinary(false).build();

    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Username").isBinary(false).build();

    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Password").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> RETRYOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryOptions")
            .isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3CONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3Configuration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> PROCESSINGCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ProcessingConfiguration").isBinary(false).build();

    private static final MarshallingInfo<String> S3BACKUPMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BackupMode").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3BACKUPCONFIGURATION_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3BackupConfiguration").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> CLOUDWATCHLOGGINGOPTIONS_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLoggingOptions").isBinary(false).build();

    private static final RedshiftDestinationConfigurationMarshaller INSTANCE = new RedshiftDestinationConfigurationMarshaller();

    private RedshiftDestinationConfigurationMarshaller() {
    }

    public static RedshiftDestinationConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(RedshiftDestinationConfiguration redshiftDestinationConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(redshiftDestinationConfiguration, "redshiftDestinationConfiguration");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(redshiftDestinationConfiguration.roleARN(), ROLEARN_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.clusterJDBCURL(), CLUSTERJDBCURL_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.copyCommand(), COPYCOMMAND_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.username(), USERNAME_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.retryOptions(), RETRYOPTIONS_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.s3Configuration(), S3CONFIGURATION_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.processingConfiguration(),
                    PROCESSINGCONFIGURATION_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.s3BackupModeAsString(), S3BACKUPMODE_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.s3BackupConfiguration(), S3BACKUPCONFIGURATION_BINDING);
            protocolMarshaller.marshall(redshiftDestinationConfiguration.cloudWatchLoggingOptions(),
                    CLOUDWATCHLOGGINGOPTIONS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
