/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * SplunkDestinationConfiguration JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SplunkDestinationConfigurationUnmarshaller implements
        Unmarshaller<SplunkDestinationConfiguration, JsonUnmarshallerContext> {

    public SplunkDestinationConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        SplunkDestinationConfiguration.Builder splunkDestinationConfigurationBuilder = SplunkDestinationConfiguration.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("HECEndpoint", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.hecEndpoint(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HECEndpointType", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.hecEndpointType(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("HECToken", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.hecToken(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("HECAcknowledgmentTimeoutInSeconds", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.hecAcknowledgmentTimeoutInSeconds(context
                            .getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("RetryOptions", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.retryOptions(SplunkRetryOptionsUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("S3BackupMode", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.s3BackupMode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("S3Configuration", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.s3Configuration(S3DestinationConfigurationUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("ProcessingConfiguration", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.processingConfiguration(ProcessingConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("CloudWatchLoggingOptions", targetDepth)) {
                    context.nextToken();
                    splunkDestinationConfigurationBuilder.cloudWatchLoggingOptions(CloudWatchLoggingOptionsUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return splunkDestinationConfigurationBuilder.build();
    }

    private static final SplunkDestinationConfigurationUnmarshaller INSTANCE = new SplunkDestinationConfigurationUnmarshaller();

    public static SplunkDestinationConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
