/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputProcessingConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of a processor that is used to preprocess the records in the stream prior to being processed
 * by your application code. Currently, the only input processor available is <a
 * href="https://aws.amazon.com/documentation/lambda/">AWS Lambda</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InputProcessingConfiguration implements StructuredPojo,
        ToCopyableBuilder<InputProcessingConfiguration.Builder, InputProcessingConfiguration> {
    private final InputLambdaProcessor inputLambdaProcessor;

    private InputProcessingConfiguration(BuilderImpl builder) {
        this.inputLambdaProcessor = builder.inputLambdaProcessor;
    }

    /**
     * <p>
     * The <a>InputLambdaProcessor</a> that is used to preprocess the records in the stream prior to being processed by
     * your application code.
     * </p>
     * 
     * @return The <a>InputLambdaProcessor</a> that is used to preprocess the records in the stream prior to being
     *         processed by your application code.
     */
    public InputLambdaProcessor inputLambdaProcessor() {
        return inputLambdaProcessor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLambdaProcessor());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputProcessingConfiguration)) {
            return false;
        }
        InputProcessingConfiguration other = (InputProcessingConfiguration) obj;
        return Objects.equals(inputLambdaProcessor(), other.inputLambdaProcessor());
    }

    @Override
    public String toString() {
        return ToString.builder("InputProcessingConfiguration").add("InputLambdaProcessor", inputLambdaProcessor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLambdaProcessor":
            return Optional.of(clazz.cast(inputLambdaProcessor()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputProcessingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InputProcessingConfiguration> {
        /**
         * <p>
         * The <a>InputLambdaProcessor</a> that is used to preprocess the records in the stream prior to being processed
         * by your application code.
         * </p>
         * 
         * @param inputLambdaProcessor
         *        The <a>InputLambdaProcessor</a> that is used to preprocess the records in the stream prior to being
         *        processed by your application code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLambdaProcessor(InputLambdaProcessor inputLambdaProcessor);

        /**
         * <p>
         * The <a>InputLambdaProcessor</a> that is used to preprocess the records in the stream prior to being processed
         * by your application code.
         * </p>
         * This is a convenience that creates an instance of the {@link InputLambdaProcessor.Builder} avoiding the need
         * to create one manually via {@link InputLambdaProcessor#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLambdaProcessor.Builder#build()} is called immediately and
         * its result is passed to {@link #inputLambdaProcessor(InputLambdaProcessor)}.
         * 
         * @param inputLambdaProcessor
         *        a consumer that will call methods on {@link InputLambdaProcessor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLambdaProcessor(InputLambdaProcessor)
         */
        default Builder inputLambdaProcessor(Consumer<InputLambdaProcessor.Builder> inputLambdaProcessor) {
            return inputLambdaProcessor(InputLambdaProcessor.builder().apply(inputLambdaProcessor).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InputLambdaProcessor inputLambdaProcessor;

        private BuilderImpl() {
        }

        private BuilderImpl(InputProcessingConfiguration model) {
            inputLambdaProcessor(model.inputLambdaProcessor);
        }

        public final InputLambdaProcessor.Builder getInputLambdaProcessor() {
            return inputLambdaProcessor != null ? inputLambdaProcessor.toBuilder() : null;
        }

        @Override
        public final Builder inputLambdaProcessor(InputLambdaProcessor inputLambdaProcessor) {
            this.inputLambdaProcessor = inputLambdaProcessor;
            return this;
        }

        public final void setInputLambdaProcessor(InputLambdaProcessor.BuilderImpl inputLambdaProcessor) {
            this.inputLambdaProcessor = inputLambdaProcessor != null ? inputLambdaProcessor.build() : null;
        }

        @Override
        public InputProcessingConfiguration build() {
            return new InputProcessingConfiguration(this);
        }
    }
}
