/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.OutputMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes application output configuration in which you identify an in-application stream and a destination where you
 * want the in-application stream data to be written. The destination can be an Amazon Kinesis stream or an Amazon
 * Kinesis Firehose delivery stream.
 * </p>
 * <p/>
 * <p>
 * For limits on how many destinations an application can write and other limitations, see <a
 * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html">Limits</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Output implements StructuredPojo, ToCopyableBuilder<Output.Builder, Output> {
    private final String name;

    private final KinesisStreamsOutput kinesisStreamsOutput;

    private final KinesisFirehoseOutput kinesisFirehoseOutput;

    private final DestinationSchema destinationSchema;

    private Output(BuilderImpl builder) {
        this.name = builder.name;
        this.kinesisStreamsOutput = builder.kinesisStreamsOutput;
        this.kinesisFirehoseOutput = builder.kinesisFirehoseOutput;
        this.destinationSchema = builder.destinationSchema;
    }

    /**
     * <p>
     * Name of the in-application stream.
     * </p>
     * 
     * @return Name of the in-application stream.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Identifies an Amazon Kinesis stream as the destination.
     * </p>
     * 
     * @return Identifies an Amazon Kinesis stream as the destination.
     */
    public KinesisStreamsOutput kinesisStreamsOutput() {
        return kinesisStreamsOutput;
    }

    /**
     * <p>
     * Identifies an Amazon Kinesis Firehose delivery stream as the destination.
     * </p>
     * 
     * @return Identifies an Amazon Kinesis Firehose delivery stream as the destination.
     */
    public KinesisFirehoseOutput kinesisFirehoseOutput() {
        return kinesisFirehoseOutput;
    }

    /**
     * Returns the value of the DestinationSchema property for this object.
     * 
     * @return The value of the DestinationSchema property for this object.
     */
    public DestinationSchema destinationSchema() {
        return destinationSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsOutput());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseOutput());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSchema());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(kinesisStreamsOutput(), other.kinesisStreamsOutput())
                && Objects.equals(kinesisFirehoseOutput(), other.kinesisFirehoseOutput())
                && Objects.equals(destinationSchema(), other.destinationSchema());
    }

    @Override
    public String toString() {
        return ToString.builder("Output").add("Name", name()).add("KinesisStreamsOutput", kinesisStreamsOutput())
                .add("KinesisFirehoseOutput", kinesisFirehoseOutput()).add("DestinationSchema", destinationSchema()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "KinesisStreamsOutput":
            return Optional.of(clazz.cast(kinesisStreamsOutput()));
        case "KinesisFirehoseOutput":
            return Optional.of(clazz.cast(kinesisFirehoseOutput()));
        case "DestinationSchema":
            return Optional.of(clazz.cast(destinationSchema()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Output> {
        /**
         * <p>
         * Name of the in-application stream.
         * </p>
         * 
         * @param name
         *        Name of the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Identifies an Amazon Kinesis stream as the destination.
         * </p>
         * 
         * @param kinesisStreamsOutput
         *        Identifies an Amazon Kinesis stream as the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsOutput(KinesisStreamsOutput kinesisStreamsOutput);

        /**
         * <p>
         * Identifies an Amazon Kinesis stream as the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsOutput.Builder} avoiding the need
         * to create one manually via {@link KinesisStreamsOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisStreamsOutput(KinesisStreamsOutput)}.
         * 
         * @param kinesisStreamsOutput
         *        a consumer that will call methods on {@link KinesisStreamsOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsOutput(KinesisStreamsOutput)
         */
        default Builder kinesisStreamsOutput(Consumer<KinesisStreamsOutput.Builder> kinesisStreamsOutput) {
            return kinesisStreamsOutput(KinesisStreamsOutput.builder().apply(kinesisStreamsOutput).build());
        }

        /**
         * <p>
         * Identifies an Amazon Kinesis Firehose delivery stream as the destination.
         * </p>
         * 
         * @param kinesisFirehoseOutput
         *        Identifies an Amazon Kinesis Firehose delivery stream as the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseOutput(KinesisFirehoseOutput kinesisFirehoseOutput);

        /**
         * <p>
         * Identifies an Amazon Kinesis Firehose delivery stream as the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseOutput.Builder} avoiding the need
         * to create one manually via {@link KinesisFirehoseOutput#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseOutput.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisFirehoseOutput(KinesisFirehoseOutput)}.
         * 
         * @param kinesisFirehoseOutput
         *        a consumer that will call methods on {@link KinesisFirehoseOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseOutput(KinesisFirehoseOutput)
         */
        default Builder kinesisFirehoseOutput(Consumer<KinesisFirehoseOutput.Builder> kinesisFirehoseOutput) {
            return kinesisFirehoseOutput(KinesisFirehoseOutput.builder().apply(kinesisFirehoseOutput).build());
        }

        /**
         * Sets the value of the DestinationSchema property for this object.
         *
         * @param destinationSchema
         *        The new value for the DestinationSchema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSchema(DestinationSchema destinationSchema);

        /**
         * Sets the value of the DestinationSchema property for this object.
         *
         * This is a convenience that creates an instance of the {@link DestinationSchema.Builder} avoiding the need to
         * create one manually via {@link DestinationSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSchema(DestinationSchema)}.
         * 
         * @param destinationSchema
         *        a consumer that will call methods on {@link DestinationSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSchema(DestinationSchema)
         */
        default Builder destinationSchema(Consumer<DestinationSchema.Builder> destinationSchema) {
            return destinationSchema(DestinationSchema.builder().apply(destinationSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private KinesisStreamsOutput kinesisStreamsOutput;

        private KinesisFirehoseOutput kinesisFirehoseOutput;

        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            name(model.name);
            kinesisStreamsOutput(model.kinesisStreamsOutput);
            kinesisFirehoseOutput(model.kinesisFirehoseOutput);
            destinationSchema(model.destinationSchema);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final KinesisStreamsOutput.Builder getKinesisStreamsOutput() {
            return kinesisStreamsOutput != null ? kinesisStreamsOutput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisStreamsOutput(KinesisStreamsOutput kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput;
            return this;
        }

        public final void setKinesisStreamsOutput(KinesisStreamsOutput.BuilderImpl kinesisStreamsOutput) {
            this.kinesisStreamsOutput = kinesisStreamsOutput != null ? kinesisStreamsOutput.build() : null;
        }

        public final KinesisFirehoseOutput.Builder getKinesisFirehoseOutput() {
            return kinesisFirehoseOutput != null ? kinesisFirehoseOutput.toBuilder() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutput(KinesisFirehoseOutput kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput;
            return this;
        }

        public final void setKinesisFirehoseOutput(KinesisFirehoseOutput.BuilderImpl kinesisFirehoseOutput) {
            this.kinesisFirehoseOutput = kinesisFirehoseOutput != null ? kinesisFirehoseOutput.build() : null;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return destinationSchema != null ? destinationSchema.toBuilder() : null;
        }

        @Override
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        @Override
        public Output build() {
            return new Output(this);
        }
    }
}
