/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.transform.S3ReferenceDataSourceUpdateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the
 * Amazon S3 object on your behalf and populate the in-application reference table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3ReferenceDataSourceUpdate implements StructuredPojo,
        ToCopyableBuilder<S3ReferenceDataSourceUpdate.Builder, S3ReferenceDataSourceUpdate> {
    private final String bucketARNUpdate;

    private final String fileKeyUpdate;

    private final String referenceRoleARNUpdate;

    private S3ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.fileKeyUpdate = builder.fileKeyUpdate;
        this.referenceRoleARNUpdate = builder.referenceRoleARNUpdate;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the S3 bucket.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the S3 bucket.
     */
    public String bucketARNUpdate() {
        return bucketARNUpdate;
    }

    /**
     * <p>
     * Object key name.
     * </p>
     * 
     * @return Object key name.
     */
    public String fileKeyUpdate() {
        return fileKeyUpdate;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the
     * in-application.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate
     *         the in-application.
     */
    public String referenceRoleARNUpdate() {
        return referenceRoleARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(fileKeyUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(referenceRoleARNUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceUpdate)) {
            return false;
        }
        S3ReferenceDataSourceUpdate other = (S3ReferenceDataSourceUpdate) obj;
        return Objects.equals(bucketARNUpdate(), other.bucketARNUpdate())
                && Objects.equals(fileKeyUpdate(), other.fileKeyUpdate())
                && Objects.equals(referenceRoleARNUpdate(), other.referenceRoleARNUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("S3ReferenceDataSourceUpdate").add("BucketARNUpdate", bucketARNUpdate())
                .add("FileKeyUpdate", fileKeyUpdate()).add("ReferenceRoleARNUpdate", referenceRoleARNUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BucketARNUpdate":
            return Optional.of(clazz.cast(bucketARNUpdate()));
        case "FileKeyUpdate":
            return Optional.of(clazz.cast(fileKeyUpdate()));
        case "ReferenceRoleARNUpdate":
            return Optional.of(clazz.cast(referenceRoleARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReferenceDataSourceUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3ReferenceDataSourceUpdate> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the S3 bucket.
         * </p>
         * 
         * @param bucketARNUpdate
         *        Amazon Resource Name (ARN) of the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketARNUpdate(String bucketARNUpdate);

        /**
         * <p>
         * Object key name.
         * </p>
         * 
         * @param fileKeyUpdate
         *        Object key name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileKeyUpdate(String fileKeyUpdate);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate the
         * in-application.
         * </p>
         * 
         * @param referenceRoleARNUpdate
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object and populate
         *        the in-application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceRoleARNUpdate(String referenceRoleARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String bucketARNUpdate;

        private String fileKeyUpdate;

        private String referenceRoleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceUpdate model) {
            bucketARNUpdate(model.bucketARNUpdate);
            fileKeyUpdate(model.fileKeyUpdate);
            referenceRoleARNUpdate(model.referenceRoleARNUpdate);
        }

        public final String getBucketARNUpdate() {
            return bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        public final String getFileKeyUpdate() {
            return fileKeyUpdate;
        }

        @Override
        public final Builder fileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
            return this;
        }

        public final void setFileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
        }

        public final String getReferenceRoleARNUpdate() {
            return referenceRoleARNUpdate;
        }

        @Override
        public final Builder referenceRoleARNUpdate(String referenceRoleARNUpdate) {
            this.referenceRoleARNUpdate = referenceRoleARNUpdate;
            return this;
        }

        public final void setReferenceRoleARNUpdate(String referenceRoleARNUpdate) {
            this.referenceRoleARNUpdate = referenceRoleARNUpdate;
        }

        @Override
        public S3ReferenceDataSourceUpdate build() {
            return new S3ReferenceDataSourceUpdate(this);
        }
    }
}
