/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateApplicationRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<UpdateApplicationRequest.Builder, UpdateApplicationRequest> {
    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final ApplicationUpdate applicationUpdate;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.applicationUpdate = builder.applicationUpdate;
    }

    /**
     * <p>
     * Name of the Amazon Kinesis Analytics application to update.
     * </p>
     * 
     * @return Name of the Amazon Kinesis Analytics application to update.
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The current application version ID. You can use the <a>DescribeApplication</a> operation to get this value.
     * </p>
     * 
     * @return The current application version ID. You can use the <a>DescribeApplication</a> operation to get this
     *         value.
     */
    public Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * Describes application updates.
     * </p>
     * 
     * @return Describes application updates.
     */
    public ApplicationUpdate applicationUpdate() {
        return applicationUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(applicationUpdate(), other.applicationUpdate());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateApplicationRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId()).add("ApplicationUpdate", applicationUpdate())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.of(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.of(clazz.cast(currentApplicationVersionId()));
        case "ApplicationUpdate":
            return Optional.of(clazz.cast(applicationUpdate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, CopyableBuilder<Builder, UpdateApplicationRequest> {
        /**
         * <p>
         * Name of the Amazon Kinesis Analytics application to update.
         * </p>
         * 
         * @param applicationName
         *        Name of the Amazon Kinesis Analytics application to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The current application version ID. You can use the <a>DescribeApplication</a> operation to get this value.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The current application version ID. You can use the <a>DescribeApplication</a> operation to get this
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * Describes application updates.
         * </p>
         * 
         * @param applicationUpdate
         *        Describes application updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationUpdate(ApplicationUpdate applicationUpdate);

        /**
         * <p>
         * Describes application updates.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationUpdate.Builder} avoiding the need to
         * create one manually via {@link ApplicationUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationUpdate(ApplicationUpdate)}.
         * 
         * @param applicationUpdate
         *        a consumer that will call methods on {@link ApplicationUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationUpdate(ApplicationUpdate)
         */
        default Builder applicationUpdate(Consumer<ApplicationUpdate.Builder> applicationUpdate) {
            return applicationUpdate(ApplicationUpdate.builder().apply(applicationUpdate).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private ApplicationUpdate applicationUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            applicationUpdate(model.applicationUpdate);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        public final ApplicationUpdate.Builder getApplicationUpdate() {
            return applicationUpdate != null ? applicationUpdate.toBuilder() : null;
        }

        @Override
        public final Builder applicationUpdate(ApplicationUpdate applicationUpdate) {
            this.applicationUpdate = applicationUpdate;
            return this;
        }

        public final void setApplicationUpdate(ApplicationUpdate.BuilderImpl applicationUpdate) {
            this.applicationUpdate = applicationUpdate != null ? applicationUpdate.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }
    }
}
