/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ApplicationUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ApplicationUpdateMarshaller {
    private static final MarshallingInfo<List> INPUTUPDATES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputUpdates").isBinary(false).build();

    private static final MarshallingInfo<String> APPLICATIONCODEUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationCodeUpdate").isBinary(false).build();

    private static final MarshallingInfo<List> OUTPUTUPDATES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUpdates").isBinary(false).build();

    private static final MarshallingInfo<List> REFERENCEDATASOURCEUPDATES_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceDataSourceUpdates").isBinary(false)
            .build();

    private static final MarshallingInfo<List> CLOUDWATCHLOGGINGOPTIONUPDATES_BINDING = MarshallingInfo
            .builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("CloudWatchLoggingOptionUpdates").isBinary(false).build();

    private static final ApplicationUpdateMarshaller INSTANCE = new ApplicationUpdateMarshaller();

    private ApplicationUpdateMarshaller() {
    }

    public static ApplicationUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ApplicationUpdate applicationUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(applicationUpdate, "applicationUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(applicationUpdate.inputUpdates(), INPUTUPDATES_BINDING);
            protocolMarshaller.marshall(applicationUpdate.applicationCodeUpdate(), APPLICATIONCODEUPDATE_BINDING);
            protocolMarshaller.marshall(applicationUpdate.outputUpdates(), OUTPUTUPDATES_BINDING);
            protocolMarshaller.marshall(applicationUpdate.referenceDataSourceUpdates(), REFERENCEDATASOURCEUPDATES_BINDING);
            protocolMarshaller.marshall(applicationUpdate.cloudWatchLoggingOptionUpdates(),
                    CLOUDWATCHLOGGINGOPTIONUPDATES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
