/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link InputUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class InputUpdateMarshaller {
    private static final MarshallingInfo<String> INPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputId").isBinary(false).build();

    private static final MarshallingInfo<String> NAMEPREFIXUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamePrefixUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputProcessingConfigurationUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSINPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamsInputUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEINPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisFirehoseInputUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTSCHEMAUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputSchemaUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> INPUTPARALLELISMUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("InputParallelismUpdate").isBinary(false).build();

    private static final InputUpdateMarshaller INSTANCE = new InputUpdateMarshaller();

    private InputUpdateMarshaller() {
    }

    public static InputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(InputUpdate inputUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(inputUpdate, "inputUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(inputUpdate.inputId(), INPUTID_BINDING);
            protocolMarshaller.marshall(inputUpdate.namePrefixUpdate(), NAMEPREFIXUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.inputProcessingConfigurationUpdate(),
                    INPUTPROCESSINGCONFIGURATIONUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.kinesisStreamsInputUpdate(), KINESISSTREAMSINPUTUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.kinesisFirehoseInputUpdate(), KINESISFIREHOSEINPUTUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.inputSchemaUpdate(), INPUTSCHEMAUPDATE_BINDING);
            protocolMarshaller.marshall(inputUpdate.inputParallelismUpdate(), INPUTPARALLELISMUPDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
