/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.OutputUpdate;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link OutputUpdate} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class OutputUpdateMarshaller {
    private static final MarshallingInfo<String> OUTPUTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputId").isBinary(false).build();

    private static final MarshallingInfo<String> NAMEUPDATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NameUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISSTREAMSOUTPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisStreamsOutputUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> KINESISFIREHOSEOUTPUTUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("KinesisFirehoseOutputUpdate").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DESTINATIONSCHEMAUPDATE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("DestinationSchemaUpdate").isBinary(false).build();

    private static final OutputUpdateMarshaller INSTANCE = new OutputUpdateMarshaller();

    private OutputUpdateMarshaller() {
    }

    public static OutputUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(OutputUpdate outputUpdate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(outputUpdate, "outputUpdate");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(outputUpdate.outputId(), OUTPUTID_BINDING);
            protocolMarshaller.marshall(outputUpdate.nameUpdate(), NAMEUPDATE_BINDING);
            protocolMarshaller.marshall(outputUpdate.kinesisStreamsOutputUpdate(), KINESISSTREAMSOUTPUTUPDATE_BINDING);
            protocolMarshaller.marshall(outputUpdate.kinesisFirehoseOutputUpdate(), KINESISFIREHOSEOUTPUTUPDATE_BINDING);
            protocolMarshaller.marshall(outputUpdate.destinationSchemaUpdate(), DESTINATIONSCHEMAUPDATE_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
