/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.transform;

import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link ReferenceDataSource} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class ReferenceDataSourceMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> S3REFERENCEDATASOURCE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("S3ReferenceDataSource").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> REFERENCESCHEMA_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("ReferenceSchema").isBinary(false).build();

    private static final ReferenceDataSourceMarshaller INSTANCE = new ReferenceDataSourceMarshaller();

    private ReferenceDataSourceMarshaller() {
    }

    public static ReferenceDataSourceMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(ReferenceDataSource referenceDataSource, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(referenceDataSource, "referenceDataSource");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(referenceDataSource.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(referenceDataSource.s3ReferenceDataSource(), S3REFERENCEDATASOURCE_BINDING);
            protocolMarshaller.marshall(referenceDataSource.referenceSchema(), REFERENCESCHEMA_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}
