/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <a>DecreaseStreamRetentionPeriod</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DecreaseStreamRetentionPeriodRequest extends KinesisRequest implements
        ToCopyableBuilder<DecreaseStreamRetentionPeriodRequest.Builder, DecreaseStreamRetentionPeriodRequest> {
    private final String streamName;

    private final Integer retentionPeriodHours;

    private DecreaseStreamRetentionPeriodRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.retentionPeriodHours = builder.retentionPeriodHours;
    }

    /**
     * <p>
     * The name of the stream to modify.
     * </p>
     * 
     * @return The name of the stream to modify.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The new retention period of the stream, in hours. Must be less than the current retention period.
     * </p>
     * 
     * @return The new retention period of the stream, in hours. Must be less than the current retention period.
     */
    public Integer retentionPeriodHours() {
        return retentionPeriodHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodHours());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecreaseStreamRetentionPeriodRequest)) {
            return false;
        }
        DecreaseStreamRetentionPeriodRequest other = (DecreaseStreamRetentionPeriodRequest) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(retentionPeriodHours(), other.retentionPeriodHours());
    }

    @Override
    public String toString() {
        return ToString.builder("DecreaseStreamRetentionPeriodRequest").add("StreamName", streamName())
                .add("RetentionPeriodHours", retentionPeriodHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "RetentionPeriodHours":
            return Optional.ofNullable(clazz.cast(retentionPeriodHours()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisRequest.Builder, CopyableBuilder<Builder, DecreaseStreamRetentionPeriodRequest> {
        /**
         * <p>
         * The name of the stream to modify.
         * </p>
         * 
         * @param streamName
         *        The name of the stream to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The new retention period of the stream, in hours. Must be less than the current retention period.
         * </p>
         * 
         * @param retentionPeriodHours
         *        The new retention period of the stream, in hours. Must be less than the current retention period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodHours(Integer retentionPeriodHours);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private Integer retentionPeriodHours;

        private BuilderImpl() {
        }

        private BuilderImpl(DecreaseStreamRetentionPeriodRequest model) {
            super(model);
            streamName(model.streamName);
            retentionPeriodHours(model.retentionPeriodHours);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getRetentionPeriodHours() {
            return retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DecreaseStreamRetentionPeriodRequest build() {
            return new DecreaseStreamRetentionPeriodRequest(this);
        }
    }
}
