/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopStreamEncryptionRequest extends KinesisRequest implements
        ToCopyableBuilder<StopStreamEncryptionRequest.Builder, StopStreamEncryptionRequest> {
    private final String streamName;

    private final String encryptionType;

    private final String keyId;

    private StopStreamEncryptionRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.encryptionType = builder.encryptionType;
        this.keyId = builder.keyId;
    }

    /**
     * <p>
     * The name of the stream on which to stop encrypting records.
     * </p>
     * 
     * @return The name of the stream on which to stop encrypting records.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The encryption type. The only valid value is <code>KMS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type. The only valid value is <code>KMS</code>.
     * @see EncryptionType
     */
    public EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The encryption type. The only valid value is <code>KMS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type. The only valid value is <code>KMS</code>.
     * @see EncryptionType
     */
    public String encryptionTypeAsString() {
        return encryptionType;
    }

    /**
     * <p>
     * The GUID for the customer-managed KMS key to use for encryption. This value can be a globally unique identifier,
     * a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".You can also use a
     * master key owned by Kinesis Streams by specifying the alias <code>aws/kinesis</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Alias name example: <code>alias/MyAliasName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Master key owned by Kinesis Streams: <code>alias/aws/kinesis</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The GUID for the customer-managed KMS key to use for encryption. This value can be a globally unique
     *         identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".You
     *         can also use a master key owned by Kinesis Streams by specifying the alias <code>aws/kinesis</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Alias name example: <code>alias/MyAliasName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Master key owned by Kinesis Streams: <code>alias/aws/kinesis</code>
     *         </p>
     *         </li>
     */
    public String keyId() {
        return keyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(keyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopStreamEncryptionRequest)) {
            return false;
        }
        StopStreamEncryptionRequest other = (StopStreamEncryptionRequest) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString())
                && Objects.equals(keyId(), other.keyId());
    }

    @Override
    public String toString() {
        return ToString.builder("StopStreamEncryptionRequest").add("StreamName", streamName())
                .add("EncryptionType", encryptionTypeAsString()).add("KeyId", keyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        case "KeyId":
            return Optional.ofNullable(clazz.cast(keyId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisRequest.Builder, CopyableBuilder<Builder, StopStreamEncryptionRequest> {
        /**
         * <p>
         * The name of the stream on which to stop encrypting records.
         * </p>
         * 
         * @param streamName
         *        The name of the stream on which to stop encrypting records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The encryption type. The only valid value is <code>KMS</code>.
         * </p>
         * 
         * @param encryptionType
         *        The encryption type. The only valid value is <code>KMS</code>.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The encryption type. The only valid value is <code>KMS</code>.
         * </p>
         * 
         * @param encryptionType
         *        The encryption type. The only valid value is <code>KMS</code>.
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);

        /**
         * <p>
         * The GUID for the customer-managed KMS key to use for encryption. This value can be a globally unique
         * identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by "alias/".You can
         * also use a master key owned by Kinesis Streams by specifying the alias <code>aws/kinesis</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Key ARN example: <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Alias name example: <code>alias/MyAliasName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Master key owned by Kinesis Streams: <code>alias/aws/kinesis</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param keyId
         *        The GUID for the customer-managed KMS key to use for encryption. This value can be a globally unique
         *        identifier, a fully specified ARN to either an alias or a key, or an alias name prefixed by
         *        "alias/".You can also use a master key owned by Kinesis Streams by specifying the alias
         *        <code>aws/kinesis</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Key ARN example:
         *        <code>arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias ARN example: <code>arn:aws:kms:us-east-1:123456789012:alias/MyAliasName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Globally unique key ID example: <code>12345678-1234-1234-1234-123456789012</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Alias name example: <code>alias/MyAliasName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Master key owned by Kinesis Streams: <code>alias/aws/kinesis</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyId(String keyId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private String encryptionType;

        private String keyId;

        private BuilderImpl() {
        }

        private BuilderImpl(StopStreamEncryptionRequest model) {
            super(model);
            streamName(model.streamName);
            encryptionType(model.encryptionType);
            keyId(model.keyId);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        public final String getKeyId() {
            return keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopStreamEncryptionRequest build() {
            return new StopStreamEncryptionRequest(this);
        }
    }
}
