/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterStreamConsumerRequest extends KinesisRequest implements
        ToCopyableBuilder<RegisterStreamConsumerRequest.Builder, RegisterStreamConsumerRequest> {
    private final String streamARN;

    private final String consumerName;

    private RegisterStreamConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.consumerName = builder.consumerName;
    }

    /**
     * <p>
     * The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     * >Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.
     * </p>
     * 
     * @return The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a
     *         href
     *         ="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     *         >Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't have to be
     * unique across data streams.
     * </p>
     * 
     * @return For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't
     *         have to be unique across data streams.
     */
    public String consumerName() {
        return consumerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(consumerName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterStreamConsumerRequest)) {
            return false;
        }
        RegisterStreamConsumerRequest other = (RegisterStreamConsumerRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(consumerName(), other.consumerName());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterStreamConsumerRequest").add("StreamARN", streamARN())
                .add("ConsumerName", consumerName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "ConsumerName":
            return Optional.ofNullable(clazz.cast(consumerName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends KinesisRequest.Builder, CopyableBuilder<Builder, RegisterStreamConsumerRequest> {
        /**
         * <p>
         * The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         * >Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         *        >Amazon Resource Names (ARNs) and AWS Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't have to
         * be unique across data streams.
         * </p>
         * 
         * @param consumerName
         *        For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't
         *        have to be unique across data streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerName(String consumerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String consumerName;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterStreamConsumerRequest model) {
            super(model);
            streamARN(model.streamARN);
            consumerName(model.consumerName);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getConsumerName() {
            return consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterStreamConsumerRequest build() {
            return new RegisterStreamConsumerRequest(this);
        }
    }
}
