/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.transform.StartingPositionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartingPosition implements StructuredPojo, ToCopyableBuilder<StartingPosition.Builder, StartingPosition> {
    private final String type;

    private final String sequenceNumber;

    private final Instant timestamp;

    private StartingPosition(BuilderImpl builder) {
        this.type = builder.type;
        this.sequenceNumber = builder.sequenceNumber;
        this.timestamp = builder.timestamp;
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see ShardIteratorType
     */
    public ShardIteratorType type() {
        return ShardIteratorType.fromValue(type);
    }

    /**
     * Returns the value of the Type property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The value of the Type property for this object.
     * @see ShardIteratorType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * Returns the value of the SequenceNumber property for this object.
     * 
     * @return The value of the SequenceNumber property for this object.
     */
    public String sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * Returns the value of the Timestamp property for this object.
     * 
     * @return The value of the Timestamp property for this object.
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartingPosition)) {
            return false;
        }
        StartingPosition other = (StartingPosition) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(sequenceNumber(), other.sequenceNumber())
                && Objects.equals(timestamp(), other.timestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("StartingPosition").add("Type", typeAsString()).add("SequenceNumber", sequenceNumber())
                .add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StartingPositionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, StartingPosition> {
        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder type(String type);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder type(ShardIteratorType type);

        /**
         * Sets the value of the SequenceNumber property for this object.
         *
         * @param sequenceNumber
         *        The new value for the SequenceNumber property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        /**
         * Sets the value of the Timestamp property for this object.
         *
         * @param timestamp
         *        The new value for the Timestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String sequenceNumber;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StartingPosition model) {
            type(model.type);
            sequenceNumber(model.sequenceNumber);
            timestamp(model.timestamp);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShardIteratorType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public StartingPosition build() {
            return new StartingPosition(this);
        }
    }
}
