/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesis.model.HashKeyRange;
import software.amazon.awssdk.services.kinesis.model.SequenceNumberRange;
import software.amazon.awssdk.services.kinesis.transform.ShardMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Shard
implements StructuredPojo,
ToCopyableBuilder<Builder, Shard> {
    private final String shardId;
    private final String parentShardId;
    private final String adjacentParentShardId;
    private final HashKeyRange hashKeyRange;
    private final SequenceNumberRange sequenceNumberRange;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.parentShardId = builder.parentShardId;
        this.adjacentParentShardId = builder.adjacentParentShardId;
        this.hashKeyRange = builder.hashKeyRange;
        this.sequenceNumberRange = builder.sequenceNumberRange;
    }

    public String shardId() {
        return this.shardId;
    }

    public String parentShardId() {
        return this.parentShardId;
    }

    public String adjacentParentShardId() {
        return this.adjacentParentShardId;
    }

    public HashKeyRange hashKeyRange() {
        return this.hashKeyRange;
    }

    public SequenceNumberRange sequenceNumberRange() {
        return this.sequenceNumberRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentShardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjacentParentShardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumberRange());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)obj;
        return Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.parentShardId(), other.parentShardId()) && Objects.equals(this.adjacentParentShardId(), other.adjacentParentShardId()) && Objects.equals(this.hashKeyRange(), other.hashKeyRange()) && Objects.equals(this.sequenceNumberRange(), other.sequenceNumberRange());
    }

    public String toString() {
        return ToString.builder((String)"Shard").add("ShardId", (Object)this.shardId()).add("ParentShardId", (Object)this.parentShardId()).add("AdjacentParentShardId", (Object)this.adjacentParentShardId()).add("HashKeyRange", (Object)this.hashKeyRange()).add("SequenceNumberRange", (Object)this.sequenceNumberRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "ParentShardId": {
                return Optional.ofNullable(clazz.cast(this.parentShardId()));
            }
            case "AdjacentParentShardId": {
                return Optional.ofNullable(clazz.cast(this.adjacentParentShardId()));
            }
            case "HashKeyRange": {
                return Optional.ofNullable(clazz.cast(this.hashKeyRange()));
            }
            case "SequenceNumberRange": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumberRange()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String shardId;
        private String parentShardId;
        private String adjacentParentShardId;
        private HashKeyRange hashKeyRange;
        private SequenceNumberRange sequenceNumberRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            this.shardId(model.shardId);
            this.parentShardId(model.parentShardId);
            this.adjacentParentShardId(model.adjacentParentShardId);
            this.hashKeyRange(model.hashKeyRange);
            this.sequenceNumberRange(model.sequenceNumberRange);
        }

        public final String getShardId() {
            return this.shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getParentShardId() {
            return this.parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        public final String getAdjacentParentShardId() {
            return this.adjacentParentShardId;
        }

        @Override
        public final Builder adjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
            return this;
        }

        public final void setAdjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
        }

        public final HashKeyRange.Builder getHashKeyRange() {
            return this.hashKeyRange != null ? this.hashKeyRange.toBuilder() : null;
        }

        @Override
        public final Builder hashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
            return this;
        }

        public final void setHashKeyRange(HashKeyRange.BuilderImpl hashKeyRange) {
            this.hashKeyRange = hashKeyRange != null ? hashKeyRange.build() : null;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return this.sequenceNumberRange != null ? this.sequenceNumberRange.toBuilder() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        public Shard build() {
            return new Shard(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Shard> {
        public Builder shardId(String var1);

        public Builder parentShardId(String var1);

        public Builder adjacentParentShardId(String var1);

        public Builder hashKeyRange(HashKeyRange var1);

        default public Builder hashKeyRange(Consumer<HashKeyRange.Builder> hashKeyRange) {
            return this.hashKeyRange((HashKeyRange)((HashKeyRange.Builder)HashKeyRange.builder().applyMutation(hashKeyRange)).build());
        }

        public Builder sequenceNumberRange(SequenceNumberRange var1);

        default public Builder sequenceNumberRange(Consumer<SequenceNumberRange.Builder> sequenceNumberRange) {
            return this.sequenceNumberRange((SequenceNumberRange)((SequenceNumberRange.Builder)SequenceNumberRange.builder().applyMutation(sequenceNumberRange)).build());
        }
    }
}

