/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesis.model.Record;
import software.amazon.awssdk.services.kinesis.model.RecordListCopier;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardEventStream;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardResponseHandler;
import software.amazon.awssdk.services.kinesis.transform.SubscribeToShardEventMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribeToShardEvent
implements StructuredPojo,
ToCopyableBuilder<Builder, SubscribeToShardEvent>,
SubscribeToShardEventStream {
    private final List<Record> records;
    private final String continuationSequenceNumber;
    private final Long millisBehindLatest;

    private SubscribeToShardEvent(BuilderImpl builder) {
        this.records = builder.records;
        this.continuationSequenceNumber = builder.continuationSequenceNumber;
        this.millisBehindLatest = builder.millisBehindLatest;
    }

    public List<Record> records() {
        return this.records;
    }

    public String continuationSequenceNumber() {
        return this.continuationSequenceNumber;
    }

    public Long millisBehindLatest() {
        return this.millisBehindLatest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.millisBehindLatest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeToShardEvent)) {
            return false;
        }
        SubscribeToShardEvent other = (SubscribeToShardEvent)obj;
        return Objects.equals(this.records(), other.records()) && Objects.equals(this.continuationSequenceNumber(), other.continuationSequenceNumber()) && Objects.equals(this.millisBehindLatest(), other.millisBehindLatest());
    }

    public String toString() {
        return ToString.builder((String)"SubscribeToShardEvent").add("Records", this.records()).add("ContinuationSequenceNumber", (Object)this.continuationSequenceNumber()).add("MillisBehindLatest", (Object)this.millisBehindLatest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "ContinuationSequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.continuationSequenceNumber()));
            }
            case "MillisBehindLatest": {
                return Optional.ofNullable(clazz.cast(this.millisBehindLatest()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscribeToShardEventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    @Override
    public void accept(SubscribeToShardResponseHandler.Visitor visitor) {
        visitor.visit(this);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();
        private String continuationSequenceNumber;
        private Long millisBehindLatest;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeToShardEvent model) {
            this.records(model.records);
            this.continuationSequenceNumber(model.continuationSequenceNumber);
            this.millisBehindLatest(model.millisBehindLatest);
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (Record)((Record.Builder)Record.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getContinuationSequenceNumber() {
            return this.continuationSequenceNumber;
        }

        @Override
        public final Builder continuationSequenceNumber(String continuationSequenceNumber) {
            this.continuationSequenceNumber = continuationSequenceNumber;
            return this;
        }

        public final void setContinuationSequenceNumber(String continuationSequenceNumber) {
            this.continuationSequenceNumber = continuationSequenceNumber;
        }

        public final Long getMillisBehindLatest() {
            return this.millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        public SubscribeToShardEvent build() {
            return new SubscribeToShardEvent(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SubscribeToShardEvent> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder records(Consumer<Record.Builder> ... var1);

        public Builder continuationSequenceNumber(String var1);

        public Builder millisBehindLatest(Long var1);
    }
}

