/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ElasticsearchDestinationUpdate JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ElasticsearchDestinationUpdateUnmarshaller implements
        Unmarshaller<ElasticsearchDestinationUpdate, JsonUnmarshallerContext> {

    public ElasticsearchDestinationUpdate unmarshall(JsonUnmarshallerContext context) throws Exception {
        ElasticsearchDestinationUpdate.Builder elasticsearchDestinationUpdateBuilder = ElasticsearchDestinationUpdate.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.roleARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DomainARN", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.domainARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IndexName", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.indexName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TypeName", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.typeName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("IndexRotationPeriod", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.indexRotationPeriod(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("BufferingHints", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.bufferingHints(ElasticsearchBufferingHintsUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("RetryOptions", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.retryOptions(ElasticsearchRetryOptionsUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("S3Update", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.s3Update(S3DestinationUpdateUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("ProcessingConfiguration", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.processingConfiguration(ProcessingConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("CloudWatchLoggingOptions", targetDepth)) {
                    context.nextToken();
                    elasticsearchDestinationUpdateBuilder.cloudWatchLoggingOptions(CloudWatchLoggingOptionsUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return elasticsearchDestinationUpdateBuilder.build();
    }

    private static final ElasticsearchDestinationUpdateUnmarshaller INSTANCE = new ElasticsearchDestinationUpdateUnmarshaller();

    public static ElasticsearchDestinationUpdateUnmarshaller getInstance() {
        return INSTANCE;
    }
}
