/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>ListStreams</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListStreamsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListStreamsRequest.Builder, ListStreamsRequest> {
    private final Integer limit;

    private final String exclusiveStartStreamName;

    private ListStreamsRequest(BuilderImpl builder) {
        this.limit = builder.limit;
        this.exclusiveStartStreamName = builder.exclusiveStartStreamName;
    }

    /**
     * <p>
     * The maximum number of streams to list.
     * </p>
     * 
     * @return The maximum number of streams to list.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The name of the stream to start the list with.
     * </p>
     * 
     * @return The name of the stream to start the list with.
     */
    public String exclusiveStartStreamName() {
        return exclusiveStartStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((exclusiveStartStreamName() == null) ? 0 : exclusiveStartStreamName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsRequest)) {
            return false;
        }
        ListStreamsRequest other = (ListStreamsRequest) obj;
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartStreamName() == null ^ this.exclusiveStartStreamName() == null) {
            return false;
        }
        if (other.exclusiveStartStreamName() != null && !other.exclusiveStartStreamName().equals(this.exclusiveStartStreamName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartStreamName() != null) {
            sb.append("ExclusiveStartStreamName: ").append(exclusiveStartStreamName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListStreamsRequest> {
        /**
         * <p>
         * The maximum number of streams to list.
         * </p>
         * 
         * @param limit
         *        The maximum number of streams to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The name of the stream to start the list with.
         * </p>
         * 
         * @param exclusiveStartStreamName
         *        The name of the stream to start the list with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartStreamName(String exclusiveStartStreamName);
    }

    private static final class BuilderImpl implements Builder {
        private Integer limit;

        private String exclusiveStartStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsRequest model) {
            setLimit(model.limit);
            setExclusiveStartStreamName(model.exclusiveStartStreamName);
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartStreamName() {
            return exclusiveStartStreamName;
        }

        @Override
        public final Builder exclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
            return this;
        }

        public final void setExclusiveStartStreamName(String exclusiveStartStreamName) {
            this.exclusiveStartStreamName = exclusiveStartStreamName;
        }

        @Override
        public ListStreamsRequest build() {
            return new ListStreamsRequest(this);
        }
    }
}
