/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TBD
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateApplicationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private final String applicationName;

    private final String applicationDescription;

    private final List<Input> inputs;

    private final List<Output> outputs;

    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;

    private final String applicationCode;

    private CreateApplicationRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.applicationCode = builder.applicationCode;
    }

    /**
     * <p>
     * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
     * </p>
     * 
     * @return Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
     */
    public String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Summary description of the application.
     * </p>
     * 
     * @return Summary description of the application.
     */
    public String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * Use this parameter to configure the application input.
     * </p>
     * <p>
     * You can configure your application to receive input from a single streaming source. In this configuration, you
     * map this streaming source to an in-application stream that is created. Your application code can then query the
     * in-application stream like a table (you can think of it as a constantly updating table).
     * </p>
     * <p>
     * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
     * example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read this
     * stream on your behalf.
     * </p>
     * <p>
     * To create the in-application stream, you need to specify a schema to transform your data into a schematized
     * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
     * source to record columns in the in-app stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Use this parameter to configure the application input.</p>
     *         <p>
     *         You can configure your application to receive input from a single streaming source. In this
     *         configuration, you map this streaming source to an in-application stream that is created. Your
     *         application code can then query the in-application stream like a table (you can think of it as a
     *         constantly updating table).
     *         </p>
     *         <p>
     *         For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
     *         (for example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume
     *         to read this stream on your behalf.
     *         </p>
     *         <p>
     *         To create the in-application stream, you need to specify a schema to transform your data into a
     *         schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in
     *         the streaming source to record columns in the in-app stream.
     */
    public List<Input> inputs() {
        return inputs;
    }

    /**
     * <p>
     * You can configure application output to write data from any of the in-application streams to up to five
     * destinations.
     * </p>
     * <p>
     * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
     * </p>
     * <p>
     * In the configuration, you specify the in-application stream name, the destination stream Amazon Resource Name
     * (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis Analytics
     * can assume to write to the destination stream on your behalf.
     * </p>
     * <p>
     * In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format of data
     * in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics can
     * assume to write to this stream on your behalf.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return You can configure application output to write data from any of the in-application streams to up to five
     *         destinations.</p>
     *         <p>
     *         These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
     *         </p>
     *         <p>
     *         In the configuration, you specify the in-application stream name, the destination stream Amazon Resource
     *         Name (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon
     *         Kinesis Analytics can assume to write to the destination stream on your behalf.
     *         </p>
     *         <p>
     *         In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format
     *         of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis
     *         Analytics can assume to write to this stream on your behalf.
     */
    public List<Output> outputs() {
        return outputs;
    }

    /**
     * <p>
     * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html">Monitoring
     * Configuration Errors</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For
     *         more information, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
     *         >Monitoring Configuration Errors</a>.
     */
    public List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * One or more SQL statements that read input data, transform it, and generate output. For example, you can write a
     * SQL statement that reads data from one in-application stream, generates a running average of the number of
     * advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more
     * inforamtion about the typical pattern, see <a
     * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a>.
     * </p>
     * <p>
     * You can provide such series of SQL statements, where output of one statement can be used as the input for the
     * next statement. You store intermediate results by creating in-application streams and pumps.
     * </p>
     * <p>
     * Note that the application code must create the streams with names specified in the <code>Outputs</code>. For
     * example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and
     * <code>ExampleOutputStream2</code>, then your application code must create these streams.
     * </p>
     * 
     * @return One or more SQL statements that read input data, transform it, and generate output. For example, you can
     *         write a SQL statement that reads data from one in-application stream, generates a running average of the
     *         number of advertisement clicks by vendor, and insert resulting rows in another in-application stream
     *         using pumps. For more inforamtion about the typical pattern, see <a
     *         href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
     *         Code</a>. </p>
     *         <p>
     *         You can provide such series of SQL statements, where output of one statement can be used as the input for
     *         the next statement. You store intermediate results by creating in-application streams and pumps.
     *         </p>
     *         <p>
     *         Note that the application code must create the streams with names specified in the <code>Outputs</code>.
     *         For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code>
     *         and <code>ExampleOutputStream2</code>, then your application code must create these streams.
     */
    public String applicationCode() {
        return applicationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((applicationName() == null) ? 0 : applicationName().hashCode());
        hashCode = 31 * hashCode + ((applicationDescription() == null) ? 0 : applicationDescription().hashCode());
        hashCode = 31 * hashCode + ((inputs() == null) ? 0 : inputs().hashCode());
        hashCode = 31 * hashCode + ((outputs() == null) ? 0 : outputs().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLoggingOptions() == null) ? 0 : cloudWatchLoggingOptions().hashCode());
        hashCode = 31 * hashCode + ((applicationCode() == null) ? 0 : applicationCode().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        if (other.applicationName() == null ^ this.applicationName() == null) {
            return false;
        }
        if (other.applicationName() != null && !other.applicationName().equals(this.applicationName())) {
            return false;
        }
        if (other.applicationDescription() == null ^ this.applicationDescription() == null) {
            return false;
        }
        if (other.applicationDescription() != null && !other.applicationDescription().equals(this.applicationDescription())) {
            return false;
        }
        if (other.inputs() == null ^ this.inputs() == null) {
            return false;
        }
        if (other.inputs() != null && !other.inputs().equals(this.inputs())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() != null && !other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions())) {
            return false;
        }
        if (other.applicationCode() == null ^ this.applicationCode() == null) {
            return false;
        }
        if (other.applicationCode() != null && !other.applicationCode().equals(this.applicationCode())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (applicationName() != null) {
            sb.append("ApplicationName: ").append(applicationName()).append(",");
        }
        if (applicationDescription() != null) {
            sb.append("ApplicationDescription: ").append(applicationDescription()).append(",");
        }
        if (inputs() != null) {
            sb.append("Inputs: ").append(inputs()).append(",");
        }
        if (outputs() != null) {
            sb.append("Outputs: ").append(outputs()).append(",");
        }
        if (cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(cloudWatchLoggingOptions()).append(",");
        }
        if (applicationCode() != null) {
            sb.append("ApplicationCode: ").append(applicationCode()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
         * </p>
         * 
         * @param applicationName
         *        Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Summary description of the application.
         * </p>
         * 
         * @param applicationDescription
         *        Summary description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * Use this parameter to configure the application input.
         * </p>
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration,
         * you map this streaming source to an in-application stream that is created. Your application code can then
         * query the in-application stream like a table (you can think of it as a constantly updating table).
         * </p>
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
         * example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
         * this stream on your behalf.
         * </p>
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized
         * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
         * source to record columns in the in-app stream.
         * </p>
         * 
         * @param inputs
         *        Use this parameter to configure the application input.</p>
         *        <p>
         *        You can configure your application to receive input from a single streaming source. In this
         *        configuration, you map this streaming source to an in-application stream that is created. Your
         *        application code can then query the in-application stream like a table (you can think of it as a
         *        constantly updating table).
         *        </p>
         *        <p>
         *        For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
         *        (for example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can
         *        assume to read this stream on your behalf.
         *        </p>
         *        <p>
         *        To create the in-application stream, you need to specify a schema to transform your data into a
         *        schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements
         *        in the streaming source to record columns in the in-app stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<Input> inputs);

        /**
         * <p>
         * Use this parameter to configure the application input.
         * </p>
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration,
         * you map this streaming source to an in-application stream that is created. Your application code can then
         * query the in-application stream like a table (you can think of it as a constantly updating table).
         * </p>
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
         * example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
         * this stream on your behalf.
         * </p>
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized
         * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
         * source to record columns in the in-app stream.
         * </p>
         * 
         * @param inputs
         *        Use this parameter to configure the application input.</p>
         *        <p>
         *        You can configure your application to receive input from a single streaming source. In this
         *        configuration, you map this streaming source to an in-application stream that is created. Your
         *        application code can then query the in-application stream like a table (you can think of it as a
         *        constantly updating table).
         *        </p>
         *        <p>
         *        For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
         *        (for example, JSON, CSV, etc). You also must provide an IAM role that Amazon Kinesis Analytics can
         *        assume to read this stream on your behalf.
         *        </p>
         *        <p>
         *        To create the in-application stream, you need to specify a schema to transform your data into a
         *        schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements
         *        in the streaming source to record columns in the in-app stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Input... inputs);

        /**
         * <p>
         * You can configure application output to write data from any of the in-application streams to up to five
         * destinations.
         * </p>
         * <p>
         * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         * </p>
         * <p>
         * In the configuration, you specify the in-application stream name, the destination stream Amazon Resource Name
         * (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis
         * Analytics can assume to write to the destination stream on your behalf.
         * </p>
         * <p>
         * In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format of
         * data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics
         * can assume to write to this stream on your behalf.
         * </p>
         * 
         * @param outputs
         *        You can configure application output to write data from any of the in-application streams to up to
         *        five destinations.</p>
         *        <p>
         *        These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         *        </p>
         *        <p>
         *        In the configuration, you specify the in-application stream name, the destination stream Amazon
         *        Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
         *        Amazon Kinesis Analytics can assume to write to the destination stream on your behalf.
         *        </p>
         *        <p>
         *        In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the
         *        format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon
         *        Kinesis Analytics can assume to write to this stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * You can configure application output to write data from any of the in-application streams to up to five
         * destinations.
         * </p>
         * <p>
         * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         * </p>
         * <p>
         * In the configuration, you specify the in-application stream name, the destination stream Amazon Resource Name
         * (ARN), and the format to use when writing data. You must also provide an IAM role that Amazon Kinesis
         * Analytics can assume to write to the destination stream on your behalf.
         * </p>
         * <p>
         * In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the format of
         * data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon Kinesis Analytics
         * can assume to write to this stream on your behalf.
         * </p>
         * 
         * @param outputs
         *        You can configure application output to write data from any of the in-application streams to up to
         *        five destinations.</p>
         *        <p>
         *        These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, or both.
         *        </p>
         *        <p>
         *        In the configuration, you specify the in-application stream name, the destination stream Amazon
         *        Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
         *        Amazon Kinesis Analytics can assume to write to the destination stream on your behalf.
         *        </p>
         *        <p>
         *        In the output configuration, you also provide the output stream Amazon Resource Name (ARN) and the
         *        format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that Amazon
         *        Kinesis Analytics can assume to write to this stream on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         * >Monitoring Configuration Errors</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure a CloudWatch log stream to monitor application configuration errors.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         *        >Monitoring Configuration Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions);

        /**
         * <p>
         * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         * >Monitoring Configuration Errors</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure a CloudWatch log stream to monitor application configuration errors.
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-monitor-configuration.html"
         *        >Monitoring Configuration Errors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions);

        /**
         * <p>
         * One or more SQL statements that read input data, transform it, and generate output. For example, you can
         * write a SQL statement that reads data from one in-application stream, generates a running average of the
         * number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using
         * pumps. For more inforamtion about the typical pattern, see <a
         * href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
         * Code</a>.
         * </p>
         * <p>
         * You can provide such series of SQL statements, where output of one statement can be used as the input for the
         * next statement. You store intermediate results by creating in-application streams and pumps.
         * </p>
         * <p>
         * Note that the application code must create the streams with names specified in the <code>Outputs</code>. For
         * example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and
         * <code>ExampleOutputStream2</code>, then your application code must create these streams.
         * </p>
         * 
         * @param applicationCode
         *        One or more SQL statements that read input data, transform it, and generate output. For example, you
         *        can write a SQL statement that reads data from one in-application stream, generates a running average
         *        of the number of advertisement clicks by vendor, and insert resulting rows in another in-application
         *        stream using pumps. For more inforamtion about the typical pattern, see <a
         *        href="http://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
         *        Code</a>. </p>
         *        <p>
         *        You can provide such series of SQL statements, where output of one statement can be used as the input
         *        for the next statement. You store intermediate results by creating in-application streams and pumps.
         *        </p>
         *        <p>
         *        Note that the application code must create the streams with names specified in the
         *        <code>Outputs</code>. For example, if your <code>Outputs</code> defines output streams named
         *        <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>, then your application code
         *        must create these streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCode(String applicationCode);
    }

    private static final class BuilderImpl implements Builder {
        private String applicationName;

        private String applicationDescription;

        private List<Input> inputs;

        private List<Output> outputs;

        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions;

        private String applicationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            setApplicationName(model.applicationName);
            setApplicationDescription(model.applicationDescription);
            setInputs(model.inputs);
            setOutputs(model.outputs);
            setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            setApplicationCode(model.applicationCode);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final Collection<Input> getInputs() {
            return inputs;
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final void setInputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
        }

        public final Collection<Output> getOutputs() {
            return outputs;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        public final void setOutputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
        }

        public final Collection<CloudWatchLoggingOption> getCloudWatchLoggingOptions() {
            return cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions) {
            cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
        }

        public final String getApplicationCode() {
            return applicationCode;
        }

        @Override
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }
}
