/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus;
import software.amazon.awssdk.services.firehose.model.DestinationDescription;
import software.amazon.awssdk.services.firehose.model.DestinationDescriptionListCopier;
import software.amazon.awssdk.services.firehose.transform.DeliveryStreamDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeliveryStreamDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, DeliveryStreamDescription> {
    private final String deliveryStreamName;
    private final String deliveryStreamARN;
    private final String deliveryStreamStatus;
    private final String versionId;
    private final Instant createTimestamp;
    private final Instant lastUpdateTimestamp;
    private final List<DestinationDescription> destinations;
    private final Boolean hasMoreDestinations;

    private DeliveryStreamDescription(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.deliveryStreamARN = builder.deliveryStreamARN;
        this.deliveryStreamStatus = builder.deliveryStreamStatus;
        this.versionId = builder.versionId;
        this.createTimestamp = builder.createTimestamp;
        this.lastUpdateTimestamp = builder.lastUpdateTimestamp;
        this.destinations = builder.destinations;
        this.hasMoreDestinations = builder.hasMoreDestinations;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String deliveryStreamARN() {
        return this.deliveryStreamARN;
    }

    public String deliveryStreamStatus() {
        return this.deliveryStreamStatus;
    }

    public String versionId() {
        return this.versionId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public Instant lastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public List<DestinationDescription> destinations() {
        return this.destinations;
    }

    public Boolean hasMoreDestinations() {
        return this.hasMoreDestinations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deliveryStreamName() == null ? 0 : this.deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + (this.deliveryStreamARN() == null ? 0 : this.deliveryStreamARN().hashCode());
        hashCode = 31 * hashCode + (this.deliveryStreamStatus() == null ? 0 : this.deliveryStreamStatus().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.createTimestamp() == null ? 0 : this.createTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdateTimestamp() == null ? 0 : this.lastUpdateTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.destinations() == null ? 0 : this.destinations().hashCode());
        hashCode = 31 * hashCode + (this.hasMoreDestinations() == null ? 0 : this.hasMoreDestinations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamDescription)) {
            return false;
        }
        DeliveryStreamDescription other = (DeliveryStreamDescription)obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.deliveryStreamARN() == null ^ this.deliveryStreamARN() == null) {
            return false;
        }
        if (other.deliveryStreamARN() != null && !other.deliveryStreamARN().equals(this.deliveryStreamARN())) {
            return false;
        }
        if (other.deliveryStreamStatus() == null ^ this.deliveryStreamStatus() == null) {
            return false;
        }
        if (other.deliveryStreamStatus() != null && !other.deliveryStreamStatus().equals(this.deliveryStreamStatus())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.createTimestamp() == null ^ this.createTimestamp() == null) {
            return false;
        }
        if (other.createTimestamp() != null && !other.createTimestamp().equals(this.createTimestamp())) {
            return false;
        }
        if (other.lastUpdateTimestamp() == null ^ this.lastUpdateTimestamp() == null) {
            return false;
        }
        if (other.lastUpdateTimestamp() != null && !other.lastUpdateTimestamp().equals(this.lastUpdateTimestamp())) {
            return false;
        }
        if (other.destinations() == null ^ this.destinations() == null) {
            return false;
        }
        if (other.destinations() != null && !other.destinations().equals(this.destinations())) {
            return false;
        }
        if (other.hasMoreDestinations() == null ^ this.hasMoreDestinations() == null) {
            return false;
        }
        return other.hasMoreDestinations() == null || other.hasMoreDestinations().equals(this.hasMoreDestinations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(this.deliveryStreamName()).append(",");
        }
        if (this.deliveryStreamARN() != null) {
            sb.append("DeliveryStreamARN: ").append(this.deliveryStreamARN()).append(",");
        }
        if (this.deliveryStreamStatus() != null) {
            sb.append("DeliveryStreamStatus: ").append(this.deliveryStreamStatus()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.createTimestamp() != null) {
            sb.append("CreateTimestamp: ").append(this.createTimestamp()).append(",");
        }
        if (this.lastUpdateTimestamp() != null) {
            sb.append("LastUpdateTimestamp: ").append(this.lastUpdateTimestamp()).append(",");
        }
        if (this.destinations() != null) {
            sb.append("Destinations: ").append(this.destinations()).append(",");
        }
        if (this.hasMoreDestinations() != null) {
            sb.append("HasMoreDestinations: ").append(this.hasMoreDestinations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryStreamDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String deliveryStreamName;
        private String deliveryStreamARN;
        private String deliveryStreamStatus;
        private String versionId;
        private Instant createTimestamp;
        private Instant lastUpdateTimestamp;
        private List<DestinationDescription> destinations;
        private Boolean hasMoreDestinations;

        private BuilderImpl() {
        }

        private BuilderImpl(DeliveryStreamDescription model) {
            this.setDeliveryStreamName(model.deliveryStreamName);
            this.setDeliveryStreamARN(model.deliveryStreamARN);
            this.setDeliveryStreamStatus(model.deliveryStreamStatus);
            this.setVersionId(model.versionId);
            this.setCreateTimestamp(model.createTimestamp);
            this.setLastUpdateTimestamp(model.lastUpdateTimestamp);
            this.setDestinations(model.destinations);
            this.setHasMoreDestinations(model.hasMoreDestinations);
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getDeliveryStreamARN() {
            return this.deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        public final String getDeliveryStreamStatus() {
            return this.deliveryStreamStatus;
        }

        @Override
        public final Builder deliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
            return this;
        }

        @Override
        public final Builder deliveryStreamStatus(DeliveryStreamStatus deliveryStreamStatus) {
            this.deliveryStreamStatus(deliveryStreamStatus.toString());
            return this;
        }

        public final void setDeliveryStreamStatus(String deliveryStreamStatus) {
            this.deliveryStreamStatus = deliveryStreamStatus;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getLastUpdateTimestamp() {
            return this.lastUpdateTimestamp;
        }

        @Override
        public final Builder lastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public final void setLastUpdateTimestamp(Instant lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
        }

        public final Collection<DestinationDescription> getDestinations() {
            return this.destinations;
        }

        @Override
        public final Builder destinations(Collection<DestinationDescription> destinations) {
            this.destinations = DestinationDescriptionListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationDescription ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        public final void setDestinations(Collection<DestinationDescription> destinations) {
            this.destinations = DestinationDescriptionListCopier.copy(destinations);
        }

        public final Boolean getHasMoreDestinations() {
            return this.hasMoreDestinations;
        }

        @Override
        public final Builder hasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
            return this;
        }

        public final void setHasMoreDestinations(Boolean hasMoreDestinations) {
            this.hasMoreDestinations = hasMoreDestinations;
        }

        public DeliveryStreamDescription build() {
            return new DeliveryStreamDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeliveryStreamDescription> {
        public Builder deliveryStreamName(String var1);

        public Builder deliveryStreamARN(String var1);

        public Builder deliveryStreamStatus(String var1);

        public Builder deliveryStreamStatus(DeliveryStreamStatus var1);

        public Builder versionId(String var1);

        public Builder createTimestamp(Instant var1);

        public Builder lastUpdateTimestamp(Instant var1);

        public Builder destinations(Collection<DestinationDescription> var1);

        public Builder destinations(DestinationDescription ... var1);

        public Builder hasMoreDestinations(Boolean var1);
    }
}

