/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.CloudWatchLoggingOptions;
import software.amazon.awssdk.services.firehose.model.CopyCommand;
import software.amazon.awssdk.services.firehose.model.ProcessingConfiguration;
import software.amazon.awssdk.services.firehose.model.RedshiftRetryOptions;
import software.amazon.awssdk.services.firehose.model.RedshiftS3BackupMode;
import software.amazon.awssdk.services.firehose.model.S3DestinationDescription;
import software.amazon.awssdk.services.firehose.transform.RedshiftDestinationDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RedshiftDestinationDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, RedshiftDestinationDescription> {
    private final String roleARN;
    private final String clusterJDBCURL;
    private final CopyCommand copyCommand;
    private final String username;
    private final RedshiftRetryOptions retryOptions;
    private final S3DestinationDescription s3DestinationDescription;
    private final ProcessingConfiguration processingConfiguration;
    private final String s3BackupMode;
    private final S3DestinationDescription s3BackupDescription;
    private final CloudWatchLoggingOptions cloudWatchLoggingOptions;

    private RedshiftDestinationDescription(BuilderImpl builder) {
        this.roleARN = builder.roleARN;
        this.clusterJDBCURL = builder.clusterJDBCURL;
        this.copyCommand = builder.copyCommand;
        this.username = builder.username;
        this.retryOptions = builder.retryOptions;
        this.s3DestinationDescription = builder.s3DestinationDescription;
        this.processingConfiguration = builder.processingConfiguration;
        this.s3BackupMode = builder.s3BackupMode;
        this.s3BackupDescription = builder.s3BackupDescription;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String clusterJDBCURL() {
        return this.clusterJDBCURL;
    }

    public CopyCommand copyCommand() {
        return this.copyCommand;
    }

    public String username() {
        return this.username;
    }

    public RedshiftRetryOptions retryOptions() {
        return this.retryOptions;
    }

    public S3DestinationDescription s3DestinationDescription() {
        return this.s3DestinationDescription;
    }

    public ProcessingConfiguration processingConfiguration() {
        return this.processingConfiguration;
    }

    public String s3BackupMode() {
        return this.s3BackupMode;
    }

    public S3DestinationDescription s3BackupDescription() {
        return this.s3BackupDescription;
    }

    public CloudWatchLoggingOptions cloudWatchLoggingOptions() {
        return this.cloudWatchLoggingOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.clusterJDBCURL() == null ? 0 : this.clusterJDBCURL().hashCode());
        hashCode = 31 * hashCode + (this.copyCommand() == null ? 0 : this.copyCommand().hashCode());
        hashCode = 31 * hashCode + (this.username() == null ? 0 : this.username().hashCode());
        hashCode = 31 * hashCode + (this.retryOptions() == null ? 0 : this.retryOptions().hashCode());
        hashCode = 31 * hashCode + (this.s3DestinationDescription() == null ? 0 : this.s3DestinationDescription().hashCode());
        hashCode = 31 * hashCode + (this.processingConfiguration() == null ? 0 : this.processingConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupMode() == null ? 0 : this.s3BackupMode().hashCode());
        hashCode = 31 * hashCode + (this.s3BackupDescription() == null ? 0 : this.s3BackupDescription().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchLoggingOptions() == null ? 0 : this.cloudWatchLoggingOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftDestinationDescription)) {
            return false;
        }
        RedshiftDestinationDescription other = (RedshiftDestinationDescription)obj;
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.clusterJDBCURL() == null ^ this.clusterJDBCURL() == null) {
            return false;
        }
        if (other.clusterJDBCURL() != null && !other.clusterJDBCURL().equals(this.clusterJDBCURL())) {
            return false;
        }
        if (other.copyCommand() == null ^ this.copyCommand() == null) {
            return false;
        }
        if (other.copyCommand() != null && !other.copyCommand().equals(this.copyCommand())) {
            return false;
        }
        if (other.username() == null ^ this.username() == null) {
            return false;
        }
        if (other.username() != null && !other.username().equals(this.username())) {
            return false;
        }
        if (other.retryOptions() == null ^ this.retryOptions() == null) {
            return false;
        }
        if (other.retryOptions() != null && !other.retryOptions().equals(this.retryOptions())) {
            return false;
        }
        if (other.s3DestinationDescription() == null ^ this.s3DestinationDescription() == null) {
            return false;
        }
        if (other.s3DestinationDescription() != null && !other.s3DestinationDescription().equals(this.s3DestinationDescription())) {
            return false;
        }
        if (other.processingConfiguration() == null ^ this.processingConfiguration() == null) {
            return false;
        }
        if (other.processingConfiguration() != null && !other.processingConfiguration().equals(this.processingConfiguration())) {
            return false;
        }
        if (other.s3BackupMode() == null ^ this.s3BackupMode() == null) {
            return false;
        }
        if (other.s3BackupMode() != null && !other.s3BackupMode().equals(this.s3BackupMode())) {
            return false;
        }
        if (other.s3BackupDescription() == null ^ this.s3BackupDescription() == null) {
            return false;
        }
        if (other.s3BackupDescription() != null && !other.s3BackupDescription().equals(this.s3BackupDescription())) {
            return false;
        }
        if (other.cloudWatchLoggingOptions() == null ^ this.cloudWatchLoggingOptions() == null) {
            return false;
        }
        return other.cloudWatchLoggingOptions() == null || other.cloudWatchLoggingOptions().equals(this.cloudWatchLoggingOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.clusterJDBCURL() != null) {
            sb.append("ClusterJDBCURL: ").append(this.clusterJDBCURL()).append(",");
        }
        if (this.copyCommand() != null) {
            sb.append("CopyCommand: ").append(this.copyCommand()).append(",");
        }
        if (this.username() != null) {
            sb.append("Username: ").append(this.username()).append(",");
        }
        if (this.retryOptions() != null) {
            sb.append("RetryOptions: ").append(this.retryOptions()).append(",");
        }
        if (this.s3DestinationDescription() != null) {
            sb.append("S3DestinationDescription: ").append(this.s3DestinationDescription()).append(",");
        }
        if (this.processingConfiguration() != null) {
            sb.append("ProcessingConfiguration: ").append(this.processingConfiguration()).append(",");
        }
        if (this.s3BackupMode() != null) {
            sb.append("S3BackupMode: ").append(this.s3BackupMode()).append(",");
        }
        if (this.s3BackupDescription() != null) {
            sb.append("S3BackupDescription: ").append(this.s3BackupDescription()).append(",");
        }
        if (this.cloudWatchLoggingOptions() != null) {
            sb.append("CloudWatchLoggingOptions: ").append(this.cloudWatchLoggingOptions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RedshiftDestinationDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String roleARN;
        private String clusterJDBCURL;
        private CopyCommand copyCommand;
        private String username;
        private RedshiftRetryOptions retryOptions;
        private S3DestinationDescription s3DestinationDescription;
        private ProcessingConfiguration processingConfiguration;
        private String s3BackupMode;
        private S3DestinationDescription s3BackupDescription;
        private CloudWatchLoggingOptions cloudWatchLoggingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftDestinationDescription model) {
            this.setRoleARN(model.roleARN);
            this.setClusterJDBCURL(model.clusterJDBCURL);
            this.setCopyCommand(model.copyCommand);
            this.setUsername(model.username);
            this.setRetryOptions(model.retryOptions);
            this.setS3DestinationDescription(model.s3DestinationDescription);
            this.setProcessingConfiguration(model.processingConfiguration);
            this.setS3BackupMode(model.s3BackupMode);
            this.setS3BackupDescription(model.s3BackupDescription);
            this.setCloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClusterJDBCURL() {
            return this.clusterJDBCURL;
        }

        @Override
        public final Builder clusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
            return this;
        }

        public final void setClusterJDBCURL(String clusterJDBCURL) {
            this.clusterJDBCURL = clusterJDBCURL;
        }

        public final CopyCommand getCopyCommand() {
            return this.copyCommand;
        }

        @Override
        public final Builder copyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
            return this;
        }

        public final void setCopyCommand(CopyCommand copyCommand) {
            this.copyCommand = copyCommand;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final RedshiftRetryOptions getRetryOptions() {
            return this.retryOptions;
        }

        @Override
        public final Builder retryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public final void setRetryOptions(RedshiftRetryOptions retryOptions) {
            this.retryOptions = retryOptions;
        }

        public final S3DestinationDescription getS3DestinationDescription() {
            return this.s3DestinationDescription;
        }

        @Override
        public final Builder s3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
            return this;
        }

        public final void setS3DestinationDescription(S3DestinationDescription s3DestinationDescription) {
            this.s3DestinationDescription = s3DestinationDescription;
        }

        public final ProcessingConfiguration getProcessingConfiguration() {
            return this.processingConfiguration;
        }

        @Override
        public final Builder processingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
            return this;
        }

        public final void setProcessingConfiguration(ProcessingConfiguration processingConfiguration) {
            this.processingConfiguration = processingConfiguration;
        }

        public final String getS3BackupMode() {
            return this.s3BackupMode;
        }

        @Override
        public final Builder s3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
            return this;
        }

        @Override
        public final Builder s3BackupMode(RedshiftS3BackupMode s3BackupMode) {
            this.s3BackupMode(s3BackupMode.toString());
            return this;
        }

        public final void setS3BackupMode(String s3BackupMode) {
            this.s3BackupMode = s3BackupMode;
        }

        public final S3DestinationDescription getS3BackupDescription() {
            return this.s3BackupDescription;
        }

        @Override
        public final Builder s3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
            return this;
        }

        public final void setS3BackupDescription(S3DestinationDescription s3BackupDescription) {
            this.s3BackupDescription = s3BackupDescription;
        }

        public final CloudWatchLoggingOptions getCloudWatchLoggingOptions() {
            return this.cloudWatchLoggingOptions;
        }

        @Override
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
            return this;
        }

        public final void setCloudWatchLoggingOptions(CloudWatchLoggingOptions cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = cloudWatchLoggingOptions;
        }

        public RedshiftDestinationDescription build() {
            return new RedshiftDestinationDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RedshiftDestinationDescription> {
        public Builder roleARN(String var1);

        public Builder clusterJDBCURL(String var1);

        public Builder copyCommand(CopyCommand var1);

        public Builder username(String var1);

        public Builder retryOptions(RedshiftRetryOptions var1);

        public Builder s3DestinationDescription(S3DestinationDescription var1);

        public Builder processingConfiguration(ProcessingConfiguration var1);

        public Builder s3BackupMode(String var1);

        public Builder s3BackupMode(RedshiftS3BackupMode var1);

        public Builder s3BackupDescription(S3DestinationDescription var1);

        public Builder cloudWatchLoggingOptions(CloudWatchLoggingOptions var1);
    }
}

