/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate;

@SdkInternalApi
public class InputSchemaUpdateMarshaller {
    private static final MarshallingInfo<StructuredPojo> RECORDFORMATUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordFormatUpdate").build();
    private static final MarshallingInfo<String> RECORDENCODINGUPDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordEncodingUpdate").build();
    private static final MarshallingInfo<List> RECORDCOLUMNUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecordColumnUpdates").build();
    private static final InputSchemaUpdateMarshaller INSTANCE = new InputSchemaUpdateMarshaller();

    public static InputSchemaUpdateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InputSchemaUpdate inputSchemaUpdate, ProtocolMarshaller protocolMarshaller) {
        if (inputSchemaUpdate == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)inputSchemaUpdate.recordFormatUpdate(), RECORDFORMATUPDATE_BINDING);
            protocolMarshaller.marshall((Object)inputSchemaUpdate.recordEncodingUpdate(), RECORDENCODINGUPDATE_BINDING);
            protocolMarshaller.marshall(inputSchemaUpdate.recordColumnUpdates(), RECORDCOLUMNUPDATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

