/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.ProcessingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a data processing configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ProcessingConfiguration implements StructuredPojo,
        ToCopyableBuilder<ProcessingConfiguration.Builder, ProcessingConfiguration> {
    private final Boolean enabled;

    private final List<Processor> processors;

    private ProcessingConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.processors = builder.processors;
    }

    /**
     * <p>
     * Enables or disables data processing.
     * </p>
     * 
     * @return Enables or disables data processing.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The data processors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data processors.
     */
    public List<Processor> processors() {
        return processors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((processors() == null) ? 0 : processors().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingConfiguration)) {
            return false;
        }
        ProcessingConfiguration other = (ProcessingConfiguration) obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.processors() == null ^ this.processors() == null) {
            return false;
        }
        if (other.processors() != null && !other.processors().equals(this.processors())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (processors() != null) {
            sb.append("Processors: ").append(processors()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ProcessingConfiguration> {
        /**
         * <p>
         * Enables or disables data processing.
         * </p>
         * 
         * @param enabled
         *        Enables or disables data processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The data processors.
         * </p>
         * 
         * @param processors
         *        The data processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Collection<Processor> processors);

        /**
         * <p>
         * The data processors.
         * </p>
         * 
         * @param processors
         *        The data processors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processors(Processor... processors);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private List<Processor> processors;

        private BuilderImpl() {
        }

        private BuilderImpl(ProcessingConfiguration model) {
            setEnabled(model.enabled);
            setProcessors(model.processors);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<Processor> getProcessors() {
            return processors;
        }

        @Override
        public final Builder processors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processors(Processor... processors) {
            processors(Arrays.asList(processors));
            return this;
        }

        public final void setProcessors(Collection<Processor> processors) {
            this.processors = ProcessorListCopier.copy(processors);
        }

        @Override
        public ProcessingConfiguration build() {
            return new ProcessingConfiguration(this);
        }
    }
}
