/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * RedshiftDestinationConfiguration JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class RedshiftDestinationConfigurationUnmarshaller implements
        Unmarshaller<RedshiftDestinationConfiguration, JsonUnmarshallerContext> {

    public RedshiftDestinationConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        RedshiftDestinationConfiguration.Builder redshiftDestinationConfigurationBuilder = RedshiftDestinationConfiguration
                .builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RoleARN", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.roleARN(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ClusterJDBCURL", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.clusterJDBCURL(context.getUnmarshaller(String.class).unmarshall(
                            context));
                }
                if (context.testExpression("CopyCommand", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder
                            .copyCommand(CopyCommandUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Username", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.username(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Password", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.password(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RetryOptions", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.retryOptions(RedshiftRetryOptionsUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("S3Configuration", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.s3Configuration(S3DestinationConfigurationUnmarshaller.getInstance()
                            .unmarshall(context));
                }
                if (context.testExpression("ProcessingConfiguration", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.processingConfiguration(ProcessingConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("S3BackupMode", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.s3BackupMode(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("S3BackupConfiguration", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.s3BackupConfiguration(S3DestinationConfigurationUnmarshaller
                            .getInstance().unmarshall(context));
                }
                if (context.testExpression("CloudWatchLoggingOptions", targetDepth)) {
                    context.nextToken();
                    redshiftDestinationConfigurationBuilder.cloudWatchLoggingOptions(CloudWatchLoggingOptionsUnmarshaller
                            .getInstance().unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return redshiftDestinationConfigurationBuilder.build();
    }

    private static final RedshiftDestinationConfigurationUnmarshaller INSTANCE = new RedshiftDestinationConfigurationUnmarshaller();

    public static RedshiftDestinationConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
