/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <a>EnableEnhancedMonitoring</a> and <a>DisableEnhancedMonitoring</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DisableEnhancedMonitoringResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DisableEnhancedMonitoringResponse.Builder, DisableEnhancedMonitoringResponse> {
    private final String streamName;

    private final List<String> currentShardLevelMetrics;

    private final List<String> desiredShardLevelMetrics;

    private DisableEnhancedMonitoringResponse(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.currentShardLevelMetrics = builder.currentShardLevelMetrics;
        this.desiredShardLevelMetrics = builder.desiredShardLevelMetrics;
    }

    /**
     * <p>
     * The name of the Amazon Kinesis stream.
     * </p>
     * 
     * @return The name of the Amazon Kinesis stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * Represents the current state of the metrics that are in the enhanced state before the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the current state of the metrics that are in the enhanced state before the operation.
     * @see MetricsName
     */
    public List<String> currentShardLevelMetrics() {
        return currentShardLevelMetrics;
    }

    /**
     * <p>
     * Represents the list of all the metrics that would be in the enhanced state after the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Represents the list of all the metrics that would be in the enhanced state after the operation.
     * @see MetricsName
     */
    public List<String> desiredShardLevelMetrics() {
        return desiredShardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((streamName() == null) ? 0 : streamName().hashCode());
        hashCode = 31 * hashCode + ((currentShardLevelMetrics() == null) ? 0 : currentShardLevelMetrics().hashCode());
        hashCode = 31 * hashCode + ((desiredShardLevelMetrics() == null) ? 0 : desiredShardLevelMetrics().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableEnhancedMonitoringResponse)) {
            return false;
        }
        DisableEnhancedMonitoringResponse other = (DisableEnhancedMonitoringResponse) obj;
        if (other.streamName() == null ^ this.streamName() == null) {
            return false;
        }
        if (other.streamName() != null && !other.streamName().equals(this.streamName())) {
            return false;
        }
        if (other.currentShardLevelMetrics() == null ^ this.currentShardLevelMetrics() == null) {
            return false;
        }
        if (other.currentShardLevelMetrics() != null && !other.currentShardLevelMetrics().equals(this.currentShardLevelMetrics())) {
            return false;
        }
        if (other.desiredShardLevelMetrics() == null ^ this.desiredShardLevelMetrics() == null) {
            return false;
        }
        if (other.desiredShardLevelMetrics() != null && !other.desiredShardLevelMetrics().equals(this.desiredShardLevelMetrics())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (streamName() != null) {
            sb.append("StreamName: ").append(streamName()).append(",");
        }
        if (currentShardLevelMetrics() != null) {
            sb.append("CurrentShardLevelMetrics: ").append(currentShardLevelMetrics()).append(",");
        }
        if (desiredShardLevelMetrics() != null) {
            sb.append("DesiredShardLevelMetrics: ").append(desiredShardLevelMetrics()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DisableEnhancedMonitoringResponse> {
        /**
         * <p>
         * The name of the Amazon Kinesis stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @see MetricsName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsName
         */
        Builder currentShardLevelMetrics(Collection<String> currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @see MetricsName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsName
         */
        Builder currentShardLevelMetrics(String... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the current state of the metrics that are in the enhanced state before the operation.
         * </p>
         * 
         * @param currentShardLevelMetrics
         *        Represents the current state of the metrics that are in the enhanced state before the operation.
         * @see MetricsName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsName
         */
        Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @see MetricsName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsName
         */
        Builder desiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @see MetricsName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsName
         */
        Builder desiredShardLevelMetrics(String... desiredShardLevelMetrics);

        /**
         * <p>
         * Represents the list of all the metrics that would be in the enhanced state after the operation.
         * </p>
         * 
         * @param desiredShardLevelMetrics
         *        Represents the list of all the metrics that would be in the enhanced state after the operation.
         * @see MetricsName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricsName
         */
        Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics);
    }

    private static final class BuilderImpl implements Builder {
        private String streamName;

        private List<String> currentShardLevelMetrics;

        private List<String> desiredShardLevelMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableEnhancedMonitoringResponse model) {
            setStreamName(model.streamName);
            setCurrentShardLevelMetrics(model.currentShardLevelMetrics);
            setDesiredShardLevelMetrics(model.desiredShardLevelMetrics);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getCurrentShardLevelMetrics() {
            return currentShardLevelMetrics;
        }

        @Override
        public final Builder currentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(String... currentShardLevelMetrics) {
            currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentShardLevelMetrics(MetricsName... currentShardLevelMetrics) {
            currentShardLevelMetrics(Arrays.asList(currentShardLevelMetrics).stream().map(Object::toString)
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCurrentShardLevelMetrics(Collection<String> currentShardLevelMetrics) {
            this.currentShardLevelMetrics = MetricsNameListCopier.copy(currentShardLevelMetrics);
        }

        public final Collection<String> getDesiredShardLevelMetrics() {
            return desiredShardLevelMetrics;
        }

        @Override
        public final Builder desiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(String... desiredShardLevelMetrics) {
            desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredShardLevelMetrics(MetricsName... desiredShardLevelMetrics) {
            desiredShardLevelMetrics(Arrays.asList(desiredShardLevelMetrics).stream().map(Object::toString)
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDesiredShardLevelMetrics(Collection<String> desiredShardLevelMetrics) {
            this.desiredShardLevelMetrics = MetricsNameListCopier.copy(desiredShardLevelMetrics);
        }

        @Override
        public DisableEnhancedMonitoringResponse build() {
            return new DisableEnhancedMonitoringResponse(this);
        }
    }
}
