/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.model.KMSEncryptionConfig;
import software.amazon.awssdk.services.firehose.model.NoEncryptionConfig;
import software.amazon.awssdk.services.firehose.transform.EncryptionConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EncryptionConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private final String noEncryptionConfig;
    private final KMSEncryptionConfig kmsEncryptionConfig;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.noEncryptionConfig = builder.noEncryptionConfig;
        this.kmsEncryptionConfig = builder.kmsEncryptionConfig;
    }

    public String noEncryptionConfig() {
        return this.noEncryptionConfig;
    }

    public KMSEncryptionConfig kmsEncryptionConfig() {
        return this.kmsEncryptionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.noEncryptionConfig() == null ? 0 : this.noEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + (this.kmsEncryptionConfig() == null ? 0 : this.kmsEncryptionConfig().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        if (other.noEncryptionConfig() == null ^ this.noEncryptionConfig() == null) {
            return false;
        }
        if (other.noEncryptionConfig() != null && !other.noEncryptionConfig().equals(this.noEncryptionConfig())) {
            return false;
        }
        if (other.kmsEncryptionConfig() == null ^ this.kmsEncryptionConfig() == null) {
            return false;
        }
        return other.kmsEncryptionConfig() == null || other.kmsEncryptionConfig().equals(this.kmsEncryptionConfig());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.noEncryptionConfig() != null) {
            sb.append("NoEncryptionConfig: ").append(this.noEncryptionConfig()).append(",");
        }
        if (this.kmsEncryptionConfig() != null) {
            sb.append("KMSEncryptionConfig: ").append(this.kmsEncryptionConfig()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String noEncryptionConfig;
        private KMSEncryptionConfig kmsEncryptionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.setNoEncryptionConfig(model.noEncryptionConfig);
            this.setKMSEncryptionConfig(model.kmsEncryptionConfig);
        }

        public final String getNoEncryptionConfig() {
            return this.noEncryptionConfig;
        }

        @Override
        public final Builder noEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
            return this;
        }

        @Override
        public final Builder noEncryptionConfig(NoEncryptionConfig noEncryptionConfig) {
            this.noEncryptionConfig(noEncryptionConfig.toString());
            return this;
        }

        public final void setNoEncryptionConfig(String noEncryptionConfig) {
            this.noEncryptionConfig = noEncryptionConfig;
        }

        public final KMSEncryptionConfig getKMSEncryptionConfig() {
            return this.kmsEncryptionConfig;
        }

        @Override
        public final Builder kmsEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
            return this;
        }

        public final void setKMSEncryptionConfig(KMSEncryptionConfig kmsEncryptionConfig) {
            this.kmsEncryptionConfig = kmsEncryptionConfig;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder noEncryptionConfig(String var1);

        public Builder noEncryptionConfig(NoEncryptionConfig var1);

        public Builder kmsEncryptionConfig(KMSEncryptionConfig var1);
    }
}

