/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.kinesisanalytics.model.InputParallelismUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.InputSchemaUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisFirehoseInputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisStreamsInputUpdate;
import software.amazon.awssdk.services.kinesisanalytics.transform.InputUpdateMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputUpdate
implements StructuredPojo,
ToCopyableBuilder<Builder, InputUpdate> {
    private final String inputId;
    private final String namePrefixUpdate;
    private final KinesisStreamsInputUpdate kinesisStreamsInputUpdate;
    private final KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;
    private final InputSchemaUpdate inputSchemaUpdate;
    private final InputParallelismUpdate inputParallelismUpdate;

    private InputUpdate(BuilderImpl builder) {
        this.inputId = builder.inputId;
        this.namePrefixUpdate = builder.namePrefixUpdate;
        this.kinesisStreamsInputUpdate = builder.kinesisStreamsInputUpdate;
        this.kinesisFirehoseInputUpdate = builder.kinesisFirehoseInputUpdate;
        this.inputSchemaUpdate = builder.inputSchemaUpdate;
        this.inputParallelismUpdate = builder.inputParallelismUpdate;
    }

    public String inputId() {
        return this.inputId;
    }

    public String namePrefixUpdate() {
        return this.namePrefixUpdate;
    }

    public KinesisStreamsInputUpdate kinesisStreamsInputUpdate() {
        return this.kinesisStreamsInputUpdate;
    }

    public KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate() {
        return this.kinesisFirehoseInputUpdate;
    }

    public InputSchemaUpdate inputSchemaUpdate() {
        return this.inputSchemaUpdate;
    }

    public InputParallelismUpdate inputParallelismUpdate() {
        return this.inputParallelismUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.inputId() == null ? 0 : this.inputId().hashCode());
        hashCode = 31 * hashCode + (this.namePrefixUpdate() == null ? 0 : this.namePrefixUpdate().hashCode());
        hashCode = 31 * hashCode + (this.kinesisStreamsInputUpdate() == null ? 0 : this.kinesisStreamsInputUpdate().hashCode());
        hashCode = 31 * hashCode + (this.kinesisFirehoseInputUpdate() == null ? 0 : this.kinesisFirehoseInputUpdate().hashCode());
        hashCode = 31 * hashCode + (this.inputSchemaUpdate() == null ? 0 : this.inputSchemaUpdate().hashCode());
        hashCode = 31 * hashCode + (this.inputParallelismUpdate() == null ? 0 : this.inputParallelismUpdate().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputUpdate)) {
            return false;
        }
        InputUpdate other = (InputUpdate)obj;
        if (other.inputId() == null ^ this.inputId() == null) {
            return false;
        }
        if (other.inputId() != null && !other.inputId().equals(this.inputId())) {
            return false;
        }
        if (other.namePrefixUpdate() == null ^ this.namePrefixUpdate() == null) {
            return false;
        }
        if (other.namePrefixUpdate() != null && !other.namePrefixUpdate().equals(this.namePrefixUpdate())) {
            return false;
        }
        if (other.kinesisStreamsInputUpdate() == null ^ this.kinesisStreamsInputUpdate() == null) {
            return false;
        }
        if (other.kinesisStreamsInputUpdate() != null && !other.kinesisStreamsInputUpdate().equals(this.kinesisStreamsInputUpdate())) {
            return false;
        }
        if (other.kinesisFirehoseInputUpdate() == null ^ this.kinesisFirehoseInputUpdate() == null) {
            return false;
        }
        if (other.kinesisFirehoseInputUpdate() != null && !other.kinesisFirehoseInputUpdate().equals(this.kinesisFirehoseInputUpdate())) {
            return false;
        }
        if (other.inputSchemaUpdate() == null ^ this.inputSchemaUpdate() == null) {
            return false;
        }
        if (other.inputSchemaUpdate() != null && !other.inputSchemaUpdate().equals(this.inputSchemaUpdate())) {
            return false;
        }
        if (other.inputParallelismUpdate() == null ^ this.inputParallelismUpdate() == null) {
            return false;
        }
        return other.inputParallelismUpdate() == null || other.inputParallelismUpdate().equals(this.inputParallelismUpdate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.inputId() != null) {
            sb.append("InputId: ").append(this.inputId()).append(",");
        }
        if (this.namePrefixUpdate() != null) {
            sb.append("NamePrefixUpdate: ").append(this.namePrefixUpdate()).append(",");
        }
        if (this.kinesisStreamsInputUpdate() != null) {
            sb.append("KinesisStreamsInputUpdate: ").append(this.kinesisStreamsInputUpdate()).append(",");
        }
        if (this.kinesisFirehoseInputUpdate() != null) {
            sb.append("KinesisFirehoseInputUpdate: ").append(this.kinesisFirehoseInputUpdate()).append(",");
        }
        if (this.inputSchemaUpdate() != null) {
            sb.append("InputSchemaUpdate: ").append(this.inputSchemaUpdate()).append(",");
        }
        if (this.inputParallelismUpdate() != null) {
            sb.append("InputParallelismUpdate: ").append(this.inputParallelismUpdate()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputUpdateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String inputId;
        private String namePrefixUpdate;
        private KinesisStreamsInputUpdate kinesisStreamsInputUpdate;
        private KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate;
        private InputSchemaUpdate inputSchemaUpdate;
        private InputParallelismUpdate inputParallelismUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(InputUpdate model) {
            this.setInputId(model.inputId);
            this.setNamePrefixUpdate(model.namePrefixUpdate);
            this.setKinesisStreamsInputUpdate(model.kinesisStreamsInputUpdate);
            this.setKinesisFirehoseInputUpdate(model.kinesisFirehoseInputUpdate);
            this.setInputSchemaUpdate(model.inputSchemaUpdate);
            this.setInputParallelismUpdate(model.inputParallelismUpdate);
        }

        public final String getInputId() {
            return this.inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        public final String getNamePrefixUpdate() {
            return this.namePrefixUpdate;
        }

        @Override
        public final Builder namePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
            return this;
        }

        public final void setNamePrefixUpdate(String namePrefixUpdate) {
            this.namePrefixUpdate = namePrefixUpdate;
        }

        public final KinesisStreamsInputUpdate getKinesisStreamsInputUpdate() {
            return this.kinesisStreamsInputUpdate;
        }

        @Override
        public final Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate;
            return this;
        }

        public final void setKinesisStreamsInputUpdate(KinesisStreamsInputUpdate kinesisStreamsInputUpdate) {
            this.kinesisStreamsInputUpdate = kinesisStreamsInputUpdate;
        }

        public final KinesisFirehoseInputUpdate getKinesisFirehoseInputUpdate() {
            return this.kinesisFirehoseInputUpdate;
        }

        @Override
        public final Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate;
            return this;
        }

        public final void setKinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate kinesisFirehoseInputUpdate) {
            this.kinesisFirehoseInputUpdate = kinesisFirehoseInputUpdate;
        }

        public final InputSchemaUpdate getInputSchemaUpdate() {
            return this.inputSchemaUpdate;
        }

        @Override
        public final Builder inputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate;
            return this;
        }

        public final void setInputSchemaUpdate(InputSchemaUpdate inputSchemaUpdate) {
            this.inputSchemaUpdate = inputSchemaUpdate;
        }

        public final InputParallelismUpdate getInputParallelismUpdate() {
            return this.inputParallelismUpdate;
        }

        @Override
        public final Builder inputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate;
            return this;
        }

        public final void setInputParallelismUpdate(InputParallelismUpdate inputParallelismUpdate) {
            this.inputParallelismUpdate = inputParallelismUpdate;
        }

        public InputUpdate build() {
            return new InputUpdate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputUpdate> {
        public Builder inputId(String var1);

        public Builder namePrefixUpdate(String var1);

        public Builder kinesisStreamsInputUpdate(KinesisStreamsInputUpdate var1);

        public Builder kinesisFirehoseInputUpdate(KinesisFirehoseInputUpdate var1);

        public Builder inputSchemaUpdate(InputSchemaUpdate var1);

        public Builder inputParallelismUpdate(InputParallelismUpdate var1);
    }
}

