/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.CloudWatchLoggingOptionsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the CloudWatch logging options for your delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudWatchLoggingOptions implements StructuredPojo,
        ToCopyableBuilder<CloudWatchLoggingOptions.Builder, CloudWatchLoggingOptions> {
    private final Boolean enabled;

    private final String logGroupName;

    private final String logStreamName;

    private CloudWatchLoggingOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logGroupName = builder.logGroupName;
        this.logStreamName = builder.logStreamName;
    }

    /**
     * <p>
     * Enables or disables CloudWatch logging.
     * </p>
     * 
     * @return Enables or disables CloudWatch logging.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
     * </p>
     * 
     * @return The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
     * </p>
     * 
     * @return The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
     */
    public String logStreamName() {
        return logStreamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((enabled() == null) ? 0 : enabled().hashCode());
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((logStreamName() == null) ? 0 : logStreamName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLoggingOptions)) {
            return false;
        }
        CloudWatchLoggingOptions other = (CloudWatchLoggingOptions) obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.logStreamName() == null ^ this.logStreamName() == null) {
            return false;
        }
        if (other.logStreamName() != null && !other.logStreamName().equals(this.logStreamName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (enabled() != null) {
            sb.append("Enabled: ").append(enabled()).append(",");
        }
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (logStreamName() != null) {
            sb.append("LogStreamName: ").append(logStreamName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.of(clazz.cast(enabled()));
        case "LogGroupName":
            return Optional.of(clazz.cast(logGroupName()));
        case "LogStreamName":
            return Optional.of(clazz.cast(logStreamName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLoggingOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloudWatchLoggingOptions> {
        /**
         * <p>
         * Enables or disables CloudWatch logging.
         * </p>
         * 
         * @param enabled
         *        Enables or disables CloudWatch logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
         * </p>
         * 
         * @param logGroupName
         *        The CloudWatch group name for logging. This value is required if CloudWatch logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
         * </p>
         * 
         * @param logStreamName
         *        The CloudWatch log stream name for logging. This value is required if CloudWatch logging is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreamName(String logStreamName);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String logGroupName;

        private String logStreamName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLoggingOptions model) {
            enabled(model.enabled);
            logGroupName(model.logGroupName);
            logStreamName(model.logStreamName);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getLogStreamName() {
            return logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public CloudWatchLoggingOptions build() {
            return new CloudWatchLoggingOptions(this);
        }
    }
}
