/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeliveryStreamResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDeliveryStreamResponse.Builder, CreateDeliveryStreamResponse> {
    private final String deliveryStreamARN;

    private CreateDeliveryStreamResponse(BuilderImpl builder) {
        this.deliveryStreamARN = builder.deliveryStreamARN;
    }

    /**
     * <p>
     * The ARN of the delivery stream.
     * </p>
     * 
     * @return The ARN of the delivery stream.
     */
    public String deliveryStreamARN() {
        return deliveryStreamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamARN() == null) ? 0 : deliveryStreamARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeliveryStreamResponse)) {
            return false;
        }
        CreateDeliveryStreamResponse other = (CreateDeliveryStreamResponse) obj;
        if (other.deliveryStreamARN() == null ^ this.deliveryStreamARN() == null) {
            return false;
        }
        if (other.deliveryStreamARN() != null && !other.deliveryStreamARN().equals(this.deliveryStreamARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryStreamARN() != null) {
            sb.append("DeliveryStreamARN: ").append(deliveryStreamARN()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamARN":
            return Optional.of(clazz.cast(deliveryStreamARN()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeliveryStreamResponse> {
        /**
         * <p>
         * The ARN of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamARN
         *        The ARN of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamARN(String deliveryStreamARN);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStreamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeliveryStreamResponse model) {
            deliveryStreamARN(model.deliveryStreamARN);
        }

        public final String getDeliveryStreamARN() {
            return deliveryStreamARN;
        }

        @Override
        public final Builder deliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
            return this;
        }

        public final void setDeliveryStreamARN(String deliveryStreamARN) {
            this.deliveryStreamARN = deliveryStreamARN;
        }

        @Override
        public CreateDeliveryStreamResponse build() {
            return new CreateDeliveryStreamResponse(this);
        }
    }
}
