/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeliveryStreamRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeDeliveryStreamRequest.Builder, DescribeDeliveryStreamRequest> {
    private final String deliveryStreamName;

    private final Integer limit;

    private final String exclusiveStartDestinationId;

    private DescribeDeliveryStreamRequest(BuilderImpl builder) {
        this.deliveryStreamName = builder.deliveryStreamName;
        this.limit = builder.limit;
        this.exclusiveStartDestinationId = builder.exclusiveStartDestinationId;
    }

    /**
     * <p>
     * The name of the delivery stream.
     * </p>
     * 
     * @return The name of the delivery stream.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * The limit on the number of destinations to return. Currently, you can have one destination per delivery stream.
     * </p>
     * 
     * @return The limit on the number of destinations to return. Currently, you can have one destination per delivery
     *         stream.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The ID of the destination to start returning the destination information. Currently Firehose supports one
     * destination per delivery stream.
     * </p>
     * 
     * @return The ID of the destination to start returning the destination information. Currently Firehose supports one
     *         destination per delivery stream.
     */
    public String exclusiveStartDestinationId() {
        return exclusiveStartDestinationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deliveryStreamName() == null) ? 0 : deliveryStreamName().hashCode());
        hashCode = 31 * hashCode + ((limit() == null) ? 0 : limit().hashCode());
        hashCode = 31 * hashCode + ((exclusiveStartDestinationId() == null) ? 0 : exclusiveStartDestinationId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveryStreamRequest)) {
            return false;
        }
        DescribeDeliveryStreamRequest other = (DescribeDeliveryStreamRequest) obj;
        if (other.deliveryStreamName() == null ^ this.deliveryStreamName() == null) {
            return false;
        }
        if (other.deliveryStreamName() != null && !other.deliveryStreamName().equals(this.deliveryStreamName())) {
            return false;
        }
        if (other.limit() == null ^ this.limit() == null) {
            return false;
        }
        if (other.limit() != null && !other.limit().equals(this.limit())) {
            return false;
        }
        if (other.exclusiveStartDestinationId() == null ^ this.exclusiveStartDestinationId() == null) {
            return false;
        }
        if (other.exclusiveStartDestinationId() != null
                && !other.exclusiveStartDestinationId().equals(this.exclusiveStartDestinationId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (limit() != null) {
            sb.append("Limit: ").append(limit()).append(",");
        }
        if (exclusiveStartDestinationId() != null) {
            sb.append("ExclusiveStartDestinationId: ").append(exclusiveStartDestinationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        case "Limit":
            return Optional.of(clazz.cast(limit()));
        case "ExclusiveStartDestinationId":
            return Optional.of(clazz.cast(exclusiveStartDestinationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDeliveryStreamRequest> {
        /**
         * <p>
         * The name of the delivery stream.
         * </p>
         * 
         * @param deliveryStreamName
         *        The name of the delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * The limit on the number of destinations to return. Currently, you can have one destination per delivery
         * stream.
         * </p>
         * 
         * @param limit
         *        The limit on the number of destinations to return. Currently, you can have one destination per
         *        delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The ID of the destination to start returning the destination information. Currently Firehose supports one
         * destination per delivery stream.
         * </p>
         * 
         * @param exclusiveStartDestinationId
         *        The ID of the destination to start returning the destination information. Currently Firehose supports
         *        one destination per delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartDestinationId(String exclusiveStartDestinationId);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStreamName;

        private Integer limit;

        private String exclusiveStartDestinationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveryStreamRequest model) {
            deliveryStreamName(model.deliveryStreamName);
            limit(model.limit);
            exclusiveStartDestinationId(model.exclusiveStartDestinationId);
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartDestinationId() {
            return exclusiveStartDestinationId;
        }

        @Override
        public final Builder exclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
            return this;
        }

        public final void setExclusiveStartDestinationId(String exclusiveStartDestinationId) {
            this.exclusiveStartDestinationId = exclusiveStartDestinationId;
        }

        @Override
        public DescribeDeliveryStreamRequest build() {
            return new DescribeDeliveryStreamRequest(this);
        }
    }
}
