/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.firehose.transform.PutRecordBatchResponseEntryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result for an individual record from a <a>PutRecordBatch</a> request. If the record is successfully
 * added to your delivery stream, it receives a record ID. If the record fails to be added to your delivery stream, the
 * result includes an error code and an error message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PutRecordBatchResponseEntry implements StructuredPojo,
        ToCopyableBuilder<PutRecordBatchResponseEntry.Builder, PutRecordBatchResponseEntry> {
    private final String recordId;

    private final String errorCode;

    private final String errorMessage;

    private PutRecordBatchResponseEntry(BuilderImpl builder) {
        this.recordId = builder.recordId;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The ID of the record.
     * </p>
     * 
     * @return The ID of the record.
     */
    public String recordId() {
        return recordId;
    }

    /**
     * <p>
     * The error code for an individual record result.
     * </p>
     * 
     * @return The error code for an individual record result.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message for an individual record result.
     * </p>
     * 
     * @return The error message for an individual record result.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((recordId() == null) ? 0 : recordId().hashCode());
        hashCode = 31 * hashCode + ((errorCode() == null) ? 0 : errorCode().hashCode());
        hashCode = 31 * hashCode + ((errorMessage() == null) ? 0 : errorMessage().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordBatchResponseEntry)) {
            return false;
        }
        PutRecordBatchResponseEntry other = (PutRecordBatchResponseEntry) obj;
        if (other.recordId() == null ^ this.recordId() == null) {
            return false;
        }
        if (other.recordId() != null && !other.recordId().equals(this.recordId())) {
            return false;
        }
        if (other.errorCode() == null ^ this.errorCode() == null) {
            return false;
        }
        if (other.errorCode() != null && !other.errorCode().equals(this.errorCode())) {
            return false;
        }
        if (other.errorMessage() == null ^ this.errorMessage() == null) {
            return false;
        }
        if (other.errorMessage() != null && !other.errorMessage().equals(this.errorMessage())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (recordId() != null) {
            sb.append("RecordId: ").append(recordId()).append(",");
        }
        if (errorCode() != null) {
            sb.append("ErrorCode: ").append(errorCode()).append(",");
        }
        if (errorMessage() != null) {
            sb.append("ErrorMessage: ").append(errorMessage()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordId":
            return Optional.of(clazz.cast(recordId()));
        case "ErrorCode":
            return Optional.of(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.of(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PutRecordBatchResponseEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, PutRecordBatchResponseEntry> {
        /**
         * <p>
         * The ID of the record.
         * </p>
         * 
         * @param recordId
         *        The ID of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordId(String recordId);

        /**
         * <p>
         * The error code for an individual record result.
         * </p>
         * 
         * @param errorCode
         *        The error code for an individual record result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message for an individual record result.
         * </p>
         * 
         * @param errorMessage
         *        The error message for an individual record result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String recordId;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordBatchResponseEntry model) {
            recordId(model.recordId);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getRecordId() {
            return recordId;
        }

        @Override
        public final Builder recordId(String recordId) {
            this.recordId = recordId;
            return this;
        }

        public final void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public PutRecordBatchResponseEntry build() {
            return new PutRecordBatchResponseEntry(this);
        }
    }
}
