/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ElasticsearchBufferingHints JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ElasticsearchBufferingHintsUnmarshaller implements
        Unmarshaller<ElasticsearchBufferingHints, JsonUnmarshallerContext> {

    public ElasticsearchBufferingHints unmarshall(JsonUnmarshallerContext context) throws Exception {
        ElasticsearchBufferingHints.Builder elasticsearchBufferingHintsBuilder = ElasticsearchBufferingHints.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("IntervalInSeconds", targetDepth)) {
                    context.nextToken();
                    elasticsearchBufferingHintsBuilder.intervalInSeconds(context.getUnmarshaller(Integer.class).unmarshall(
                            context));
                }
                if (context.testExpression("SizeInMBs", targetDepth)) {
                    context.nextToken();
                    elasticsearchBufferingHintsBuilder.sizeInMBs(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return elasticsearchBufferingHintsBuilder.build();
    }

    private static final ElasticsearchBufferingHintsUnmarshaller INSTANCE = new ElasticsearchBufferingHintsUnmarshaller();

    public static ElasticsearchBufferingHintsUnmarshaller getInstance() {
        return INSTANCE;
    }
}
