/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.firehose.model.*;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * ProcessingConfiguration JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ProcessingConfigurationUnmarshaller implements Unmarshaller<ProcessingConfiguration, JsonUnmarshallerContext> {

    public ProcessingConfiguration unmarshall(JsonUnmarshallerContext context) throws Exception {
        ProcessingConfiguration.Builder processingConfigurationBuilder = ProcessingConfiguration.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    processingConfigurationBuilder.enabled(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("Processors", targetDepth)) {
                    context.nextToken();
                    processingConfigurationBuilder
                            .processors(new ListUnmarshaller<Processor>(ProcessorUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return processingConfigurationBuilder.build();
    }

    private static final ProcessingConfigurationUnmarshaller INSTANCE = new ProcessingConfigurationUnmarshaller();

    public static ProcessingConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
